/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.instance.InstanceChunkLoadEvent;
import net.minestom.server.event.instance.InstanceChunkUnloadEvent;
import net.minestom.server.event.player.PlayerBlockBreakEvent;
import net.minestom.server.instance.AnvilLoader;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.DynamicChunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.GeneratorImpl;
import net.minestom.server.instance.IChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.LightingChunk;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.SharedInstance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.block.rule.BlockPlacementRule;
import net.minestom.server.instance.generator.GenerationUnit;
import net.minestom.server.instance.generator.Generator;
import net.minestom.server.instance.generator.UnitModifier;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.network.packet.server.play.BlockChangePacket;
import net.minestom.server.network.packet.server.play.BlockEntityDataPacket;
import net.minestom.server.network.packet.server.play.EffectPacket;
import net.minestom.server.network.packet.server.play.UnloadChunkPacket;
import net.minestom.server.registry.Registry;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.chunk.ChunkCache;
import net.minestom.server.utils.chunk.ChunkSupplier;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import space.vectrix.flare.fastutil.Long2ObjectSyncMap;

public class InstanceContainer
extends Instance {
    private static final AnvilLoader DEFAULT_LOADER = new AnvilLoader("world");
    private final List<SharedInstance> sharedInstances = new CopyOnWriteArrayList<SharedInstance>();
    private volatile Generator generator;
    private final Long2ObjectSyncMap<Chunk> chunks = Long2ObjectSyncMap.hashmap();
    private final Map<Long, CompletableFuture<Chunk>> loadingChunks = new ConcurrentHashMap<Long, CompletableFuture<Chunk>>();
    private final Lock changingBlockLock = new ReentrantLock();
    private final Map<Point, Block> currentlyChangingBlocks = new HashMap<Point, Block>();
    private IChunkLoader chunkLoader;
    private boolean autoChunkLoad = true;
    private ChunkSupplier chunkSupplier;
    protected InstanceContainer srcInstance;
    private long lastBlockChangeTime;
    Map<Long, List<GeneratorImpl.SectionModifierImpl>> generationForks = new ConcurrentHashMap<Long, List<GeneratorImpl.SectionModifierImpl>>();

    @ApiStatus.Experimental
    public InstanceContainer(@NotNull UUID uniqueId, @NotNull DimensionType dimensionType, @Nullable IChunkLoader loader) {
        super(uniqueId, dimensionType);
        this.setChunkSupplier(DynamicChunk::new);
        this.setChunkLoader(Objects.requireNonNullElse(loader, DEFAULT_LOADER));
        this.chunkLoader.loadInstance(this);
    }

    public InstanceContainer(@NotNull UUID uniqueId, @NotNull DimensionType dimensionType) {
        this(uniqueId, dimensionType, null);
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block) {
        Chunk chunk = this.getChunkAt(x, z);
        if (chunk == null) {
            Check.stateCondition(!this.hasEnabledAutoChunkLoad(), "Tried to set a block to an unloaded chunk with auto chunk load disabled");
            chunk = this.loadChunk(ChunkUtils.getChunkCoordinate(x), ChunkUtils.getChunkCoordinate(z)).join();
        }
        if (ChunkUtils.isLoaded(chunk)) {
            this.UNSAFE_setBlock(chunk, x, y, z, block, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void UNSAFE_setBlock(@NotNull Chunk chunk, int x, int y, int z, @NotNull Block block, @Nullable BlockHandler.Placement placement, @Nullable BlockHandler.Destroy destroy) {
        if (chunk.isReadOnly()) {
            return;
        }
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            BlockHandler handler;
            this.lastBlockChangeTime = System.currentTimeMillis();
            Vec blockPosition = new Vec(x, y, z);
            if (this.isAlreadyChanged(blockPosition, block)) {
                return;
            }
            this.currentlyChangingBlocks.put(blockPosition, block);
            Block previousBlock = chunk.getBlock(blockPosition);
            BlockHandler previousHandler = previousBlock.handler();
            BlockPlacementRule blockPlacementRule = MinecraftServer.getBlockManager().getBlockPlacementRule(block);
            if (blockPlacementRule != null) {
                block = blockPlacementRule.blockUpdate(new BlockPlacementRule.UpdateState(this, blockPosition, block));
            }
            chunk.setBlock(x, y, z, block);
            this.executeNeighboursBlockPlacementRule(blockPosition);
            chunk.sendPacketToViewers(new BlockChangePacket((Point)blockPosition, block.stateId()));
            Registry.BlockEntry registry = block.registry();
            if (registry.isBlockEntity()) {
                NBTCompound data = BlockUtils.extractClientNbt(block);
                chunk.sendPacketToViewers(new BlockEntityDataPacket(blockPosition, registry.blockEntityId(), data));
            }
            if (previousHandler != null) {
                previousHandler.onDestroy(Objects.requireNonNullElseGet(destroy, () -> new BlockHandler.Destroy(previousBlock, this, blockPosition)));
            }
            if ((handler = block.handler()) != null) {
                Block finalBlock = block;
                handler.onPlace(Objects.requireNonNullElseGet(placement, () -> new BlockHandler.Placement(finalBlock, this, blockPosition)));
            }
        }
    }

    @Override
    public boolean placeBlock(@NotNull BlockHandler.Placement placement) {
        Point blockPosition = placement.getBlockPosition();
        Chunk chunk = this.getChunkAt(blockPosition);
        if (!ChunkUtils.isLoaded(chunk)) {
            return false;
        }
        this.UNSAFE_setBlock(chunk, blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), placement.getBlock(), placement, null);
        return true;
    }

    @Override
    public boolean breakBlock(@NotNull Player player, @NotNull Point blockPosition, @NotNull BlockFace blockFace) {
        boolean allowed;
        Chunk chunk = this.getChunkAt(blockPosition);
        Check.notNull(chunk, "You cannot break blocks in a null chunk!");
        if (chunk.isReadOnly()) {
            return false;
        }
        if (!ChunkUtils.isLoaded(chunk)) {
            return false;
        }
        Block block = this.getBlock(blockPosition);
        int x = blockPosition.blockX();
        int y = blockPosition.blockY();
        int z = blockPosition.blockZ();
        if (block.isAir()) {
            chunk.sendChunk(player);
            return false;
        }
        PlayerBlockBreakEvent blockBreakEvent = new PlayerBlockBreakEvent(player, block, Block.AIR, blockPosition, blockFace);
        EventDispatcher.call(blockBreakEvent);
        boolean bl = allowed = !blockBreakEvent.isCancelled();
        if (allowed) {
            Block resultBlock = blockBreakEvent.getResultBlock();
            this.UNSAFE_setBlock(chunk, x, y, z, resultBlock, null, new BlockHandler.PlayerDestroy(block, this, blockPosition, player));
            PacketUtils.sendGroupedPacket(chunk.getViewers(), new EffectPacket(2001, blockPosition, block.stateId(), false), viewer -> !viewer.equals(player));
        }
        return allowed;
    }

    @Override
    @NotNull
    public CompletableFuture<Chunk> loadChunk(int chunkX, int chunkZ) {
        return this.loadOrRetrieve(chunkX, chunkZ, () -> this.retrieveChunk(chunkX, chunkZ));
    }

    @Override
    @NotNull
    public CompletableFuture<Chunk> loadOptionalChunk(int chunkX, int chunkZ) {
        return this.loadOrRetrieve(chunkX, chunkZ, () -> this.hasEnabledAutoChunkLoad() ? this.retrieveChunk(chunkX, chunkZ) : AsyncUtils.empty());
    }

    @Override
    public synchronized void unloadChunk(@NotNull Chunk chunk) {
        if (!ChunkUtils.isLoaded(chunk)) {
            return;
        }
        int chunkX = chunk.getChunkX();
        int chunkZ = chunk.getChunkZ();
        chunk.sendPacketToViewers(new UnloadChunkPacket(chunkX, chunkZ));
        EventDispatcher.call(new InstanceChunkUnloadEvent(this, chunk));
        this.getEntityTracker().chunkEntities(chunkX, chunkZ, EntityTracker.Target.ENTITIES).forEach(Entity::remove);
        this.chunks.remove(ChunkUtils.getChunkIndex(chunkX, chunkZ));
        chunk.unload();
        if (this.chunkLoader != null) {
            this.chunkLoader.unloadChunk(chunk);
        }
        ThreadDispatcher<Chunk> dispatcher = MinecraftServer.process().dispatcher();
        dispatcher.deletePartition(chunk);
    }

    @Override
    public Chunk getChunk(int chunkX, int chunkZ) {
        return (Chunk)this.chunks.get(ChunkUtils.getChunkIndex(chunkX, chunkZ));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveInstance() {
        return this.chunkLoader.saveInstance(this);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveChunkToStorage(@NotNull Chunk chunk) {
        return this.chunkLoader.saveChunk(chunk);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveChunksToStorage() {
        return this.chunkLoader.saveChunks(this.getChunks());
    }

    @NotNull
    protected @NotNull CompletableFuture<@NotNull Chunk> retrieveChunk(int chunkX, int chunkZ) {
        CompletableFuture<Chunk> completableFuture = new CompletableFuture<Chunk>();
        long index = ChunkUtils.getChunkIndex(chunkX, chunkZ);
        CompletableFuture<Chunk> prev = this.loadingChunks.putIfAbsent(index, completableFuture);
        if (prev != null) {
            return prev;
        }
        IChunkLoader loader = this.chunkLoader;
        Runnable retriever = () -> ((CompletableFuture)((CompletableFuture)loader.loadChunk(this, chunkX, chunkZ).thenCompose(chunk -> {
            if (chunk != null) {
                return CompletableFuture.completedFuture(chunk);
            }
            return this.createChunk(chunkX, chunkZ);
        })).thenAccept(chunk -> {
            this.cacheChunk((Chunk)chunk);
            chunk.onLoad();
            EventDispatcher.call(new InstanceChunkLoadEvent(this, (Chunk)chunk));
            CompletableFuture<Chunk> future = this.loadingChunks.remove(index);
            assert (future == completableFuture) : "Invalid future: " + future;
            completableFuture.complete((Chunk)chunk);
        })).exceptionally(throwable -> {
            MinecraftServer.getExceptionManager().handleException((Throwable)throwable);
            return null;
        });
        if (loader.supportsParallelLoading()) {
            CompletableFuture.runAsync(retriever);
        } else {
            retriever.run();
        }
        return completableFuture;
    }

    @NotNull
    protected @NotNull CompletableFuture<@NotNull Chunk> createChunk(int chunkX, int chunkZ) {
        Chunk chunk = this.chunkSupplier.createChunk(this, chunkX, chunkZ);
        Check.notNull(chunk, "Chunks supplied by a ChunkSupplier cannot be null.");
        Generator generator = this.generator();
        if (generator != null && chunk.shouldGenerate()) {
            CompletableFuture<Chunk> resultFuture = new CompletableFuture<Chunk>();
            ForkJoinPool.commonPool().submit(() -> {
                GeneratorImpl.UnitImpl chunkUnit = GeneratorImpl.chunk(chunk);
                try {
                    generator.generate(chunkUnit);
                    UnitModifier patt14521$temp = chunkUnit.modifier();
                    if (patt14521$temp instanceof GeneratorImpl.AreaModifierImpl) {
                        GeneratorImpl.AreaModifierImpl chunkModifier = (GeneratorImpl.AreaModifierImpl)patt14521$temp;
                        for (GenerationUnit section : chunkModifier.sections()) {
                            UnitModifier patt14702$temp = section.modifier();
                            if (!(patt14702$temp instanceof GeneratorImpl.SectionModifierImpl)) continue;
                            GeneratorImpl.SectionModifierImpl sectionModifier = (GeneratorImpl.SectionModifierImpl)patt14702$temp;
                            this.applyGenerationData(chunk, sectionModifier);
                        }
                    }
                    for (GeneratorImpl.UnitImpl fork : chunkUnit.forks()) {
                        List<GenerationUnit> sections = ((GeneratorImpl.AreaModifierImpl)fork.modifier()).sections();
                        for (GenerationUnit section : sections) {
                            Chunk forkChunk;
                            GeneratorImpl.SectionModifierImpl sectionModifier;
                            UnitModifier patt15241$temp = section.modifier();
                            if (!(patt15241$temp instanceof GeneratorImpl.SectionModifierImpl) || (sectionModifier = (GeneratorImpl.SectionModifierImpl)patt15241$temp).blockPalette().count() == 0) continue;
                            Point start = section.absoluteStart();
                            Chunk chunk2 = forkChunk = start.chunkX() == chunkX && start.chunkZ() == chunkZ ? chunk : this.getChunkAt(start);
                            if (forkChunk != null) {
                                this.applyFork(forkChunk, sectionModifier);
                                if (forkChunk instanceof LightingChunk) {
                                    LightingChunk lightingChunk = (LightingChunk)forkChunk;
                                    lightingChunk.chunkCache.invalidate();
                                    lightingChunk.lightCache.invalidate();
                                } else if (forkChunk instanceof DynamicChunk) {
                                    DynamicChunk dynamicChunk = (DynamicChunk)forkChunk;
                                    dynamicChunk.chunkCache.invalidate();
                                }
                                forkChunk.sendChunk();
                                continue;
                            }
                            long index = ChunkUtils.getChunkIndex(start);
                            this.generationForks.compute(index, (i, sectionModifiers) -> {
                                if (sectionModifiers == null) {
                                    sectionModifiers = new ArrayList<GeneratorImpl.SectionModifierImpl>();
                                }
                                sectionModifiers.add(sectionModifier);
                                return sectionModifiers;
                            });
                        }
                    }
                    this.processFork(chunk);
                }
                catch (Throwable e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
                finally {
                    this.refreshLastBlockChangeTime();
                    resultFuture.complete(chunk);
                }
            });
            return resultFuture;
        }
        this.processFork(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    private void processFork(Chunk chunk) {
        this.generationForks.compute(ChunkUtils.getChunkIndex(chunk), (aLong, sectionModifiers) -> {
            if (sectionModifiers != null) {
                for (GeneratorImpl.SectionModifierImpl sectionModifier : sectionModifiers) {
                    this.applyFork(chunk, sectionModifier);
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFork(Chunk chunk, GeneratorImpl.SectionModifierImpl sectionModifier) {
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            Section section = chunk.getSectionAt(sectionModifier.start().blockY());
            Palette currentBlocks = section.blockPalette();
            sectionModifier.blockPalette().getAllPresent((x, y, z, value) -> currentBlocks.set(x, y, z, value - 1));
            this.applyGenerationData(chunk, sectionModifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyGenerationData(Chunk chunk, GeneratorImpl.SectionModifierImpl section) {
        Int2ObjectMap<Block> cache = section.cache();
        if (cache.isEmpty()) {
            return;
        }
        int height = section.start().blockY();
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            Int2ObjectMaps.fastForEach(cache, blockEntry -> {
                int index = blockEntry.getIntKey();
                Block block = (Block)blockEntry.getValue();
                int x = ChunkUtils.blockIndexToChunkPositionX(index);
                int y = ChunkUtils.blockIndexToChunkPositionY(index) + height;
                int z = ChunkUtils.blockIndexToChunkPositionZ(index);
                chunk.setBlock(x, y, z, block);
            });
        }
    }

    @Override
    public void enableAutoChunkLoad(boolean enable) {
        this.autoChunkLoad = enable;
    }

    @Override
    public boolean hasEnabledAutoChunkLoad() {
        return this.autoChunkLoad;
    }

    @Override
    public boolean isInVoid(@NotNull Point point) {
        return point.y() < (double)(this.getDimensionType().getMinY() - 64);
    }

    @Override
    public void setChunkSupplier(@NotNull ChunkSupplier chunkSupplier) {
        this.chunkSupplier = chunkSupplier;
    }

    @Override
    public ChunkSupplier getChunkSupplier() {
        return this.chunkSupplier;
    }

    public List<SharedInstance> getSharedInstances() {
        return Collections.unmodifiableList(this.sharedInstances);
    }

    public boolean hasSharedInstances() {
        return !this.sharedInstances.isEmpty();
    }

    protected void addSharedInstance(SharedInstance sharedInstance) {
        this.sharedInstances.add(sharedInstance);
    }

    public synchronized InstanceContainer copy() {
        InstanceContainer copiedInstance = new InstanceContainer(UUID.randomUUID(), this.getDimensionType());
        copiedInstance.srcInstance = this;
        copiedInstance.lastBlockChangeTime = this.lastBlockChangeTime;
        for (Chunk chunk : this.chunks.values()) {
            int chunkX = chunk.getChunkX();
            int chunkZ = chunk.getChunkZ();
            Chunk copiedChunk = chunk.copy(copiedInstance, chunkX, chunkZ);
            copiedInstance.cacheChunk(copiedChunk);
        }
        return copiedInstance;
    }

    @Nullable
    public InstanceContainer getSrcInstance() {
        return this.srcInstance;
    }

    public long getLastBlockChangeTime() {
        return this.lastBlockChangeTime;
    }

    public void refreshLastBlockChangeTime() {
        this.lastBlockChangeTime = System.currentTimeMillis();
    }

    @Override
    @Nullable
    public Generator generator() {
        return this.generator;
    }

    @Override
    public void setGenerator(@Nullable Generator generator) {
        this.generator = generator;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Chunk> getChunks() {
        return this.chunks.values();
    }

    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    public void setChunkLoader(IChunkLoader chunkLoader) {
        this.chunkLoader = chunkLoader;
    }

    @Override
    public void tick(long time) {
        super.tick(time);
        Lock wrlock = this.changingBlockLock;
        wrlock.lock();
        this.currentlyChangingBlocks.clear();
        wrlock.unlock();
    }

    private boolean isAlreadyChanged(@NotNull Point blockPosition, @NotNull Block block) {
        Block changedBlock = this.currentlyChangingBlocks.get(blockPosition);
        return Objects.equals(changedBlock, block);
    }

    private void executeNeighboursBlockPlacementRule(@NotNull Point blockPosition) {
        ChunkCache cache = new ChunkCache(this, null, null);
        for (int offsetX = -1; offsetX < 2; ++offsetX) {
            for (int offsetY = -1; offsetY < 2; ++offsetY) {
                for (int offsetZ = -1; offsetZ < 2; ++offsetZ) {
                    Vec neighborPosition;
                    Block newNeighborBlock;
                    BlockPlacementRule neighborBlockPlacementRule;
                    Block neighborBlock;
                    if (offsetX == 0 && offsetY == 0 && offsetZ == 0) continue;
                    int neighborX = blockPosition.blockX() + offsetX;
                    int neighborY = blockPosition.blockY() + offsetY;
                    int neighborZ = blockPosition.blockZ() + offsetZ;
                    if (neighborY < this.getDimensionType().getMinY() || neighborY > this.getDimensionType().getTotalHeight() || (neighborBlock = cache.getBlock(neighborX, neighborY, neighborZ, Block.Getter.Condition.TYPE)) == null || (neighborBlockPlacementRule = MinecraftServer.getBlockManager().getBlockPlacementRule(neighborBlock)) == null || neighborBlock == (newNeighborBlock = neighborBlockPlacementRule.blockUpdate(new BlockPlacementRule.UpdateState(this, neighborPosition = new Vec(neighborX, neighborY, neighborZ), neighborBlock)))) continue;
                    this.setBlock(neighborPosition, newNeighborBlock);
                }
            }
        }
    }

    private CompletableFuture<Chunk> loadOrRetrieve(int chunkX, int chunkZ, Supplier<CompletableFuture<Chunk>> supplier) {
        Chunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk != null) {
            return CompletableFuture.completedFuture(chunk);
        }
        return supplier.get();
    }

    private void cacheChunk(@NotNull Chunk chunk) {
        this.chunks.put(ChunkUtils.getChunkIndex(chunk), (Object)chunk);
        ThreadDispatcher<Chunk> dispatcher = MinecraftServer.process().dispatcher();
        dispatcher.createPartition(chunk);
    }
}

