/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minestom.server.MinecraftServer;
import net.minestom.server.collision.Shape;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.DynamicChunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.play.data.LightData;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskSchedule;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;

public class LightingChunk
extends DynamicChunk {
    private int[] heightmap;
    final CachedPacket lightCache = new CachedPacket(this::createLightPacket);
    boolean sendNeighbours = true;
    private static final Set<NamespaceID> DIFFUSE_SKY_LIGHT = Set.of(Block.COBWEB.namespace(), Block.ICE.namespace(), Block.HONEY_BLOCK.namespace(), Block.SLIME_BLOCK.namespace(), Block.WATER.namespace(), Block.ACACIA_LEAVES.namespace(), Block.AZALEA_LEAVES.namespace(), Block.BIRCH_LEAVES.namespace(), Block.DARK_OAK_LEAVES.namespace(), Block.FLOWERING_AZALEA_LEAVES.namespace(), Block.JUNGLE_LEAVES.namespace(), Block.OAK_LEAVES.namespace(), Block.SPRUCE_LEAVES.namespace(), Block.SPAWNER.namespace(), Block.BEACON.namespace(), Block.END_GATEWAY.namespace(), Block.CHORUS_PLANT.namespace(), Block.CHORUS_FLOWER.namespace(), Block.FROSTED_ICE.namespace(), Block.SEAGRASS.namespace(), Block.TALL_SEAGRASS.namespace(), Block.LAVA.namespace());
    private static final Set<LightingChunk> sendQueue = ConcurrentHashMap.newKeySet();
    private static final ReentrantLock sendQueueLock = new ReentrantLock();
    private static Task sendingTask = null;

    public LightingChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        super(instance, chunkX, chunkZ);
    }

    private boolean checkSkyOcclusion(Block block) {
        if (block == Block.AIR) {
            return false;
        }
        if (DIFFUSE_SKY_LIGHT.contains(block.namespace())) {
            return true;
        }
        Shape shape = block.registry().collisionShape();
        boolean occludesTop = Block.AIR.registry().collisionShape().isOccluded(shape, BlockFace.TOP);
        boolean occludesBottom = Block.AIR.registry().collisionShape().isOccluded(shape, BlockFace.BOTTOM);
        return occludesBottom || occludesTop;
    }

    private void invalidateSection(int coordinate) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = this.instance.getChunk(this.chunkX + i, this.chunkZ + j);
                if (neighborChunk == null) continue;
                if (neighborChunk instanceof LightingChunk) {
                    LightingChunk lightingChunk = (LightingChunk)neighborChunk;
                    lightingChunk.lightCache.invalidate();
                    lightingChunk.chunkCache.invalidate();
                }
                for (int k = -1; k <= 1; ++k) {
                    if (k + coordinate < neighborChunk.getMinSection() || k + coordinate >= neighborChunk.getMaxSection()) continue;
                    neighborChunk.getSection(k + coordinate).blockLight().invalidate();
                    neighborChunk.getSection(k + coordinate).skyLight().invalidate();
                }
            }
        }
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block) {
        super.setBlock(x, y, z, block);
        this.heightmap = null;
        int coordinate = ChunkUtils.getChunkCoordinate(y);
        this.invalidateSection(coordinate);
        this.lightCache.invalidate();
    }

    public void sendLighting() {
        if (!this.isLoaded()) {
            return;
        }
        this.sendPacketToViewers(this.lightCache);
    }

    @Override
    protected void onLoad() {
        this.chunkCache.body();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] calculateHeightMap() {
        if (this.heightmap != null) {
            return this.heightmap;
        }
        int[] heightmap = new int[256];
        int minY = this.instance.getDimensionType().getMinY();
        int maxY = this.instance.getDimensionType().getMinY() + this.instance.getDimensionType().getHeight();
        LightingChunk lightingChunk = this;
        synchronized (lightingChunk) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block;
                    int height;
                    for (height = maxY; height > minY && !this.checkSkyOcclusion(block = this.getBlock(x, height, z, Block.Getter.Condition.TYPE)); --height) {
                    }
                    heightmap[z << 4 | x] = height + 1;
                }
            }
        }
        this.heightmap = heightmap;
        return heightmap;
    }

    @Override
    protected LightData createLightData(boolean sendAll) {
        BitSet skyMask = new BitSet();
        BitSet blockMask = new BitSet();
        BitSet emptySkyMask = new BitSet();
        BitSet emptyBlockMask = new BitSet();
        ArrayList<byte[]> skyLights = new ArrayList<byte[]>();
        ArrayList<byte[]> blockLights = new ArrayList<byte[]>();
        int index = 0;
        for (Section section : this.sections) {
            boolean wasUpdatedBlock = false;
            boolean wasUpdatedSky = false;
            if (section.blockLight().requiresUpdate()) {
                LightingChunk.relightSection(this.instance, this.chunkX, index + this.minSection, this.chunkZ, LightType.BLOCK);
                wasUpdatedBlock = true;
            } else if (section.blockLight().requiresSend()) {
                wasUpdatedBlock = true;
            }
            if (section.skyLight().requiresUpdate()) {
                LightingChunk.relightSection(this.instance, this.chunkX, index + this.minSection, this.chunkZ, LightType.SKY);
                wasUpdatedSky = true;
            } else if (section.skyLight().requiresSend()) {
                wasUpdatedSky = true;
            }
            ++index;
            byte[] skyLight = section.skyLight().array();
            byte[] blockLight = section.blockLight().array();
            if ((wasUpdatedSky || sendAll && skyLight != LightCompute.emptyContent) && this.instance.getDimensionType().isSkylightEnabled()) {
                if (skyLight.length != 0) {
                    skyLights.add(skyLight);
                    skyMask.set(index);
                } else {
                    emptySkyMask.set(index);
                }
            }
            if (!wasUpdatedBlock && (!sendAll || blockLight == LightCompute.emptyContent)) continue;
            if (blockLight.length != 0) {
                blockLights.add(blockLight);
                blockMask.set(index);
                continue;
            }
            emptyBlockMask.set(index);
        }
        if (this.sendNeighbours) {
            LightingChunk.updateAfterGeneration(this);
            this.sendNeighbours = false;
        }
        return new LightData(skyMask, blockMask, emptySkyMask, emptyBlockMask, skyLights, blockLights);
    }

    private static void updateAfterGeneration(LightingChunk chunk) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = chunk.instance.getChunk(chunk.chunkX + i, chunk.chunkZ + j);
                if (neighborChunk == null || !(neighborChunk instanceof LightingChunk)) continue;
                LightingChunk lightingChunk = (LightingChunk)neighborChunk;
                sendQueue.add(lightingChunk);
            }
        }
        sendQueueLock.lock();
        if (sendingTask != null) {
            sendingTask.cancel();
        }
        sendingTask = MinecraftServer.getSchedulerManager().scheduleTask(() -> {
            sendingTask = null;
            for (LightingChunk f : sendQueue) {
                if (!f.isLoaded()) continue;
                f.sections.forEach(s -> {
                    s.blockLight().invalidate();
                    s.skyLight().invalidate();
                });
                f.chunkCache.invalidate();
                f.lightCache.invalidate();
                f.sendLighting();
            }
            sendQueue.clear();
        }, TaskSchedule.tick(10), TaskSchedule.stop(), ExecutionType.ASYNC);
        sendQueueLock.unlock();
    }

    private static void flushQueue(Instance instance, Set<Point> queue, LightType type) {
        Set<Point> updateQueue = queue.parallelStream().map(sectionLocation -> {
            Chunk chunk = instance.getChunk(sectionLocation.blockX(), sectionLocation.blockZ());
            if (chunk == null) {
                return null;
            }
            if (type == LightType.BLOCK) {
                return chunk.getSection(sectionLocation.blockY()).blockLight().calculateExternal(instance, chunk, sectionLocation.blockY());
            }
            return chunk.getSection(sectionLocation.blockY()).skyLight().calculateExternal(instance, chunk, sectionLocation.blockY());
        }).filter(Objects::nonNull).toList().parallelStream().flatMap(light -> light.flip().stream()).collect(Collectors.toSet());
        if (updateQueue.size() > 0) {
            LightingChunk.flushQueue(instance, updateQueue, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void relight(Instance instance, Collection<Chunk> chunks) {
        Set<Point> toPropagate = chunks.parallelStream().flatMap(chunk -> IntStream.range(chunk.getMinSection(), chunk.getMaxSection()).mapToObj(index -> Map.entry(index, chunk))).map(chunkIndex -> {
            Chunk chunk = (Chunk)chunkIndex.getValue();
            int section = (Integer)chunkIndex.getKey();
            chunk.getSection(section).blockLight().invalidate();
            chunk.getSection(section).skyLight().invalidate();
            return new Vec(chunk.getChunkX(), section, chunk.getChunkZ());
        }).collect(Collectors.toSet());
        Instance instance2 = instance;
        synchronized (instance2) {
            LightingChunk.relight(instance, toPropagate, LightType.BLOCK);
            LightingChunk.relight(instance, toPropagate, LightType.SKY);
        }
    }

    private static Set<Point> getNearbyRequired(Instance instance, Point point) {
        HashSet<Point> collected = new HashSet<Point>();
        collected.add(point);
        for (int x = point.blockX() - 1; x <= point.blockX() + 1; ++x) {
            for (int z = point.blockZ() - 1; z <= point.blockZ() + 1; ++z) {
                Chunk chunkCheck = instance.getChunk(x, z);
                if (chunkCheck == null) continue;
                for (int y = point.blockY() - 1; y <= point.blockY() + 1; ++y) {
                    Section s;
                    Vec sectionPosition = new Vec(x, y, z);
                    if (sectionPosition.blockY() >= chunkCheck.getMaxSection() || sectionPosition.blockY() < chunkCheck.getMinSection() || !(s = chunkCheck.getSection(sectionPosition.blockY())).blockLight().requiresUpdate() && !s.skyLight().requiresUpdate()) continue;
                    collected.add(sectionPosition);
                }
            }
        }
        return collected;
    }

    private static Set<Point> collectRequiredNearby(Instance instance, Point point) {
        HashSet<Point> found = new HashSet<Point>();
        ArrayDeque<Point> toCheck = new ArrayDeque<Point>();
        toCheck.add(point);
        found.add(point);
        while (toCheck.size() > 0) {
            Point current = (Point)toCheck.poll();
            Set<Point> nearby = LightingChunk.getNearbyRequired(instance, current);
            nearby.forEach(p -> {
                if (!found.contains(p)) {
                    found.add((Point)p);
                    toCheck.add((Point)p);
                }
            });
        }
        return found;
    }

    static void relightSection(Instance instance, int chunkX, int sectionY, int chunkZ) {
        LightingChunk.relightSection(instance, chunkX, sectionY, chunkZ, LightType.BLOCK);
        LightingChunk.relightSection(instance, chunkX, sectionY, chunkZ, LightType.SKY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void relightSection(Instance instance, int chunkX, int sectionY, int chunkZ, LightType type) {
        Chunk c = instance.getChunk(chunkX, chunkZ);
        if (c == null) {
            return;
        }
        Set<Point> collected = LightingChunk.collectRequiredNearby(instance, new Vec(chunkX, sectionY, chunkZ));
        Instance instance2 = instance;
        synchronized (instance2) {
            LightingChunk.relight(instance, collected, type);
        }
    }

    private static void relight(Instance instance, Set<Point> sections, LightType type) {
        Set<Point> toPropagate = sections.parallelStream().map(chunkIndex -> {
            Chunk chunk = instance.getChunk(chunkIndex.blockX(), chunkIndex.blockZ());
            int section = chunkIndex.blockY();
            if (chunk == null) {
                return null;
            }
            if (type == LightType.BLOCK) {
                return chunk.getSection(section).blockLight().calculateInternal(chunk.getInstance(), chunk.getChunkX(), section, chunk.getChunkZ());
            }
            return chunk.getSection(section).skyLight().calculateInternal(chunk.getInstance(), chunk.getChunkX(), section, chunk.getChunkZ());
        }).filter(Objects::nonNull).flatMap(lightSet -> lightSet.flip().stream()).collect(Collectors.toSet()).parallelStream().flatMap(sectionLocation -> {
            Chunk chunk = instance.getChunk(sectionLocation.blockX(), sectionLocation.blockZ());
            int section = sectionLocation.blockY();
            if (chunk == null) {
                return Stream.empty();
            }
            Light light = type == LightType.BLOCK ? chunk.getSection(section).blockLight() : chunk.getSection(section).skyLight();
            light.calculateExternal(chunk.getInstance(), chunk, section);
            return light.flip().stream();
        }).collect(Collectors.toSet());
        LightingChunk.flushQueue(instance, toPropagate, type);
    }

    @Override
    @NotNull
    public Chunk copy(@NotNull Instance instance, int chunkX, int chunkZ) {
        LightingChunk lightingChunk = new LightingChunk(instance, chunkX, chunkZ);
        lightingChunk.sections = this.sections.stream().map(Section::clone).toList();
        lightingChunk.entries.putAll((Map)this.entries);
        return lightingChunk;
    }

    static enum LightType {
        SKY,
        BLOCK;

    }
}

