/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public final class Section
implements NetworkBuffer.Writer {
    private final Palette blockPalette;
    private final Palette biomePalette;
    private final Light skyLight;
    private final Light blockLight;

    private Section(Palette blockPalette, Palette biomePalette) {
        this.blockPalette = blockPalette;
        this.biomePalette = biomePalette;
        this.skyLight = Light.sky(blockPalette);
        this.blockLight = Light.block(blockPalette);
    }

    public Section() {
        this(Palette.blocks(), Palette.biomes());
    }

    public Palette blockPalette() {
        return this.blockPalette;
    }

    public Palette biomePalette() {
        return this.biomePalette;
    }

    public void clear() {
        this.blockPalette.fill(0);
        this.biomePalette.fill(0);
    }

    @NotNull
    public Section clone() {
        return new Section(this.blockPalette.clone(), this.biomePalette.clone());
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.SHORT, (short)this.blockPalette.count());
        writer.write(this.blockPalette);
        writer.write(this.biomePalette);
    }

    public void setSkyLight(byte[] copyArray) {
        this.skyLight.set(copyArray);
    }

    public void setBlockLight(byte[] copyArray) {
        this.blockLight.set(copyArray);
    }

    public Light skyLight() {
        return this.skyLight;
    }

    public Light blockLight() {
        return this.blockLight;
    }
}

