/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.NotNull;

public enum BlockFace {
    BOTTOM(Direction.DOWN),
    TOP(Direction.UP),
    NORTH(Direction.NORTH),
    SOUTH(Direction.SOUTH),
    WEST(Direction.WEST),
    EAST(Direction.EAST);

    private final Direction direction;

    private BlockFace(Direction direction) {
        this.direction = direction;
    }

    public Direction toDirection() {
        return this.direction;
    }

    @NotNull
    public BlockFace getOppositeFace() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOTTOM -> TOP;
            case TOP -> BOTTOM;
            case NORTH -> SOUTH;
            case SOUTH -> NORTH;
            case WEST -> EAST;
            case EAST -> WEST;
        };
    }

    public boolean isSimilar(@NotNull BlockFace other) {
        return this == other || this == other.getOppositeFace();
    }

    public static BlockFace fromYaw(float yaw) {
        float degrees = (yaw - 90.0f) % 360.0f;
        if (degrees < 0.0f) {
            degrees += 360.0f;
        }
        if (0.0f <= degrees && degrees < 45.0f) {
            return WEST;
        }
        if (45.0f <= degrees && degrees < 135.0f) {
            return NORTH;
        }
        if (135.0f <= degrees && degrees < 225.0f) {
            return EAST;
        }
        if (225.0f <= degrees && degrees < 315.0f) {
            return SOUTH;
        }
        return WEST;
    }
}

