/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.registry.Registry;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.collection.MergedMap;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTCompoundLike;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

record BlockImpl(@NotNull Registry.BlockEntry registry, byte @NotNull [] propertiesArray, @Nullable NBTCompound nbt, @Nullable BlockHandler handler) implements Block
{
    private static final ObjectArray<Block> BLOCK_STATE_MAP = ObjectArray.singleThread();
    private static final ObjectArray<PropertyType[]> PROPERTIES_TYPE = ObjectArray.singleThread();
    private static final ObjectArray<Map<PropertiesHolder, BlockImpl>> POSSIBLE_STATES = ObjectArray.singleThread();
    private static final Registry.Container<Block> CONTAINER = Registry.createContainer(Registry.Resource.BLOCKS, (namespace, properties) -> {
        PropertyType[] propertyTypes;
        int blockId = properties.getInt("id");
        Registry.Properties stateObject = properties.section("states");
        Registry.Properties stateProperties = properties.section("properties");
        if (stateProperties != null) {
            int stateCount = stateProperties.size();
            propertyTypes = new PropertyType[stateCount];
            int i = 0;
            for (Map.Entry<String, Object> entry : stateProperties) {
                String k = entry.getKey();
                List v = (List)entry.getValue();
                propertyTypes[i++] = new PropertyType(k, v);
            }
        } else {
            propertyTypes = new PropertyType[]{};
        }
        PROPERTIES_TYPE.set(blockId, propertyTypes);
        int propertiesCount = stateObject.size();
        PropertiesHolder[] propertiesKeys = new PropertiesHolder[propertiesCount];
        BlockImpl[] blocksValues = new BlockImpl[propertiesCount];
        int propertiesOffset = 0;
        for (Map.Entry<String, Object> stateEntry : stateObject) {
            String query = stateEntry.getKey();
            Map stateOverride = (Map)stateEntry.getValue();
            Map<String, String> propertyMap = BlockUtils.parseProperties(query);
            assert (propertyTypes.length == propertyMap.size());
            byte[] propertiesArray = new byte[propertyTypes.length];
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                byte valueIndex;
                byte keyIndex = BlockImpl.findKeyIndex(propertyTypes, entry.getKey(), null);
                propertiesArray[keyIndex] = valueIndex = BlockImpl.findValueIndex(propertyTypes[keyIndex], entry.getValue(), null);
            }
            Registry.Properties mainProperties = Registry.Properties.fromMap(new MergedMap<String, Object>(stateOverride, properties.asMap()));
            BlockImpl block = new BlockImpl(Registry.block(namespace, mainProperties), propertiesArray, null, null);
            BLOCK_STATE_MAP.set(block.stateId(), block);
            propertiesKeys[propertiesOffset] = new PropertiesHolder(propertiesArray);
            blocksValues[propertiesOffset++] = block;
        }
        POSSIBLE_STATES.set(blockId, ArrayUtils.toMap(propertiesKeys, blocksValues, propertiesOffset));
        int defaultState = properties.getInt("defaultStateId");
        return BlockImpl.getState(defaultState);
    });
    private static final Cache<NBTCompound, NBTCompound> NBT_CACHE = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).weakValues().build();

    static Block get(@NotNull String namespace) {
        return CONTAINER.get(namespace);
    }

    static Block getSafe(@NotNull String namespace) {
        return CONTAINER.getSafe(namespace);
    }

    static Block getId(int id) {
        return CONTAINER.getId(id);
    }

    static Block getState(int stateId) {
        return BLOCK_STATE_MAP.get(stateId);
    }

    static Collection<Block> values() {
        return CONTAINER.values();
    }

    @Override
    @NotNull
    public Block withProperty(@NotNull String property, @NotNull String value) {
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        byte keyIndex = BlockImpl.findKeyIndex(propertyTypes, property, this);
        byte valueIndex = BlockImpl.findValueIndex(propertyTypes[keyIndex], value, this);
        byte[] properties = (byte[])this.propertiesArray.clone();
        properties[keyIndex] = valueIndex;
        return this.compute(properties);
    }

    @Override
    @NotNull
    public Block withProperties(@NotNull @NotNull Map<@NotNull String, @NotNull String> properties) {
        if (properties.isEmpty()) {
            return this;
        }
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        byte[] result = (byte[])this.propertiesArray.clone();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            byte valueIndex;
            byte keyIndex = BlockImpl.findKeyIndex(propertyTypes, entry.getKey(), this);
            result[keyIndex] = valueIndex = BlockImpl.findValueIndex(propertyTypes[keyIndex], entry.getValue(), this);
        }
        return this.compute(result);
    }

    @Override
    @NotNull
    public <T> Block withTag(@NotNull Tag<T> tag, @Nullable T value) {
        MutableNBTCompound temporaryNbt = new MutableNBTCompound(Objects.requireNonNullElse(this.nbt, NBTCompound.EMPTY));
        tag.write(temporaryNbt, value);
        NBTCompound finalNbt = temporaryNbt.getSize() > 0 ? (NBTCompound)NBT_CACHE.get((Object)temporaryNbt.toCompound(), Function.identity()) : null;
        return new BlockImpl(this.registry, this.propertiesArray, finalNbt, this.handler);
    }

    @Override
    @NotNull
    public Block withNbt(@Nullable NBTCompound compound) {
        return new BlockImpl(this.registry, this.propertiesArray, compound, this.handler);
    }

    @Override
    @NotNull
    public Block withHandler(@Nullable BlockHandler handler) {
        return new BlockImpl(this.registry, this.propertiesArray, this.nbt, handler);
    }

    @Override
    public @Unmodifiable @NotNull Map<String, String> properties() {
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        int length = propertyTypes.length;
        if (length == 0) {
            return Map.of();
        }
        Object[] keys = new String[length];
        Object[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            PropertyType property = propertyTypes[i];
            keys[i] = property.key();
            values[i] = property.values().get(this.propertiesArray[i]);
        }
        return Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectArrayMap(keys, values, length));
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Block> possibleStates() {
        return (Collection)Collection.class.cast(this.possibleProperties().values());
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return tag.read((NBTCompoundLike)Objects.requireNonNullElse(this.nbt, NBTCompound.EMPTY));
    }

    private Map<PropertiesHolder, BlockImpl> possibleProperties() {
        return POSSIBLE_STATES.get(this.id());
    }

    @Override
    public String toString() {
        return String.format("%s{properties=%s, nbt=%s, handler=%s}", this.name(), this.properties(), this.nbt, this.handler);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockImpl)) {
            return false;
        }
        BlockImpl block = (BlockImpl)o;
        return this.stateId() == block.stateId() && Objects.equals(this.nbt, block.nbt) && Objects.equals(this.handler, block.handler);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stateId(), this.nbt, this.handler);
    }

    private Block compute(byte[] properties) {
        if (Arrays.equals(this.propertiesArray, properties)) {
            return this;
        }
        BlockImpl block = this.possibleProperties().get(new PropertiesHolder(properties));
        assert (block != null);
        return this.nbt == null && this.handler == null ? block : new BlockImpl(block.registry(), block.propertiesArray, this.nbt, this.handler);
    }

    private static byte findKeyIndex(PropertyType[] properties, String key, BlockImpl block) {
        for (byte i = 0; i < properties.length; i = (byte)(i + 1)) {
            if (!properties[i].key().equals(key)) continue;
            return i;
        }
        if (block != null) {
            throw new IllegalArgumentException("Property " + key + " is not valid for block " + block);
        }
        throw new IllegalArgumentException("Unknown property key: " + key);
    }

    private static byte findValueIndex(PropertyType propertyType, String value, BlockImpl block) {
        List<String> values = propertyType.values();
        byte index = (byte)values.indexOf(value);
        if (index != -1) {
            return index;
        }
        if (block != null) {
            throw new IllegalArgumentException("Property " + propertyType.key() + " value " + value + " is not valid for block " + block);
        }
        throw new IllegalArgumentException("Unknown property value: " + value);
    }

    static {
        PROPERTIES_TYPE.trim();
        BLOCK_STATE_MAP.trim();
        POSSIBLE_STATES.trim();
    }

    private record PropertyType(String key, List<String> values) {
    }

    private static final class PropertiesHolder {
        private final byte[] properties;
        private final int hashCode;

        public PropertiesHolder(byte[] properties) {
            this.properties = properties;
            this.hashCode = Arrays.hashCode(properties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertiesHolder)) {
                return false;
            }
            PropertiesHolder that = (PropertiesHolder)o;
            return Arrays.equals(this.properties, that.properties);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

