/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.instance.palette.Palette;
import org.jetbrains.annotations.NotNull;

final class BlockLight
implements Light {
    private final Palette blockPalette;
    private byte[] content;
    private byte[] contentPropagation;
    private byte[] contentPropagationSwap;
    private byte[][] borders;
    private byte[][] bordersPropagation;
    private byte[][] bordersPropagationSwap;
    private boolean isValidBorders = true;
    private boolean needsSend = true;
    private Set<Point> toUpdateSet = new HashSet<Point>();

    BlockLight(Palette blockPalette) {
        this.blockPalette = blockPalette;
    }

    @Override
    public Set<Point> flip() {
        if (this.bordersPropagationSwap != null) {
            this.bordersPropagation = this.bordersPropagationSwap;
        }
        if (this.contentPropagationSwap != null) {
            this.contentPropagation = this.contentPropagationSwap;
        }
        this.bordersPropagationSwap = null;
        this.contentPropagationSwap = null;
        if (this.toUpdateSet == null) {
            return Set.of();
        }
        return this.toUpdateSet;
    }

    static IntArrayFIFOQueue buildInternalQueue(Palette blockPalette, Block[] blocks) {
        IntArrayFIFOQueue lightSources = new IntArrayFIFOQueue();
        blockPalette.getAllPresent((x, y, z, stateId) -> {
            Block block = Block.fromStateId((short)stateId);
            assert (block != null);
            byte lightEmission = (byte)block.registry().lightEmission();
            int index = x | z << 4 | y << 8;
            blocks[index] = block;
            if (lightEmission > 0) {
                lightSources.enqueue(index | lightEmission << 12);
            }
        });
        return lightSources;
    }

    private static Block getBlock(Palette palette, int x, int y, int z) {
        return Block.fromStateId((short)palette.get(x, y, z));
    }

    private static IntArrayFIFOQueue buildExternalQueue(Instance instance, Block[] blocks, Map<BlockFace, Point> neighbors, byte[][] borders) {
        IntArrayFIFOQueue lightSources = new IntArrayFIFOQueue();
        for (BlockFace face : BlockFace.values()) {
            byte[] neighborFace;
            Chunk chunk;
            Point neighborSection = neighbors.get((Object)face);
            if (neighborSection == null || (chunk = instance.getChunk(neighborSection.blockX(), neighborSection.blockZ())) == null || (neighborFace = chunk.getSection(neighborSection.blockY()).blockLight().getBorderPropagation(face.getOppositeFace())) == null) continue;
            for (int bx = 0; bx < 16; ++bx) {
                for (int by = 0; by < 16; ++by) {
                    Block blockFrom;
                    byte internalEmission;
                    int borderIndex = bx * 16 + by;
                    byte lightEmission = neighborFace[borderIndex];
                    if (borders != null && borders[face.ordinal()] != null && lightEmission <= (internalEmission = borders[face.ordinal()][borderIndex])) continue;
                    int k = switch (face) {
                        default -> throw new IncompatibleClassChangeError();
                        case BlockFace.WEST, BlockFace.BOTTOM, BlockFace.NORTH -> 0;
                        case BlockFace.EAST, BlockFace.TOP, BlockFace.SOUTH -> 15;
                    };
                    int posTo = switch (face) {
                        case BlockFace.NORTH, BlockFace.SOUTH -> bx | k << 4 | by << 8;
                        case BlockFace.WEST, BlockFace.EAST -> k | by << 4 | bx << 8;
                        default -> bx | by << 4 | k << 8;
                    };
                    Section otherSection = chunk.getSection(neighborSection.blockY());
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            Block block = BlockLight.getBlock(otherSection.blockPalette(), bx, by, 15 - k);
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            Block block = BlockLight.getBlock(otherSection.blockPalette(), 15 - k, bx, by);
                            break;
                        }
                        default: {
                            Block block = blockFrom = BlockLight.getBlock(otherSection.blockPalette(), bx, 15 - k, by);
                        }
                    }
                    if (blocks == null) continue;
                    Block blockTo = blocks[posTo];
                    if (blockTo == null && blockFrom != null) {
                        if (blockFrom.registry().collisionShape().isOccluded(Block.AIR.registry().collisionShape(), face.getOppositeFace())) {
                            continue;
                        }
                    } else if (blockTo == null || blockFrom != null ? blockTo != null && blockFrom != null && blockFrom.registry().collisionShape().isOccluded(blockTo.registry().collisionShape(), face.getOppositeFace()) : Block.AIR.registry().collisionShape().isOccluded(blockTo.registry().collisionShape(), face)) continue;
                    if (lightEmission <= 0) continue;
                    int index = posTo | lightEmission << 12;
                    lightSources.enqueue(index);
                }
            }
        }
        return lightSources;
    }

    @Override
    public void copyFrom(byte @NotNull [] array) {
        this.content = (byte[])(array.length == 0 ? null : (byte[])array.clone());
    }

    @Override
    public Light calculateInternal(Instance instance, int chunkX, int sectionY, int chunkZ) {
        Chunk chunk = instance.getChunk(chunkX, chunkZ);
        if (chunk == null) {
            this.toUpdateSet = Set.of();
            return this;
        }
        this.isValidBorders = true;
        HashSet<Point> toUpdate = new HashSet<Point>();
        Block[] blocks = new Block[4096];
        IntArrayFIFOQueue queue = BlockLight.buildInternalQueue(this.blockPalette, blocks);
        LightCompute.Result result = LightCompute.compute(blocks, queue);
        this.content = result.light();
        this.borders = result.borders();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = instance.getChunk(chunkX + i, chunkZ + j);
                if (neighborChunk == null) continue;
                for (int k = -1; k <= 1; ++k) {
                    Vec neighborPos = new Vec(chunkX + i, sectionY + k, chunkZ + j);
                    if (neighborPos.blockY() < neighborChunk.getMinSection() || neighborPos.blockY() >= neighborChunk.getMaxSection()) continue;
                    toUpdate.add(new Vec(neighborChunk.getChunkX(), neighborPos.blockY(), neighborChunk.getChunkZ()));
                    neighborChunk.getSection(neighborPos.blockY()).blockLight().invalidatePropagation();
                }
            }
        }
        toUpdate.add(new Vec(chunk.getChunkX(), sectionY, chunk.getChunkZ()));
        this.toUpdateSet = toUpdate;
        return this;
    }

    @Override
    public void invalidate() {
        this.invalidatePropagation();
    }

    @Override
    public boolean requiresUpdate() {
        return !this.isValidBorders;
    }

    @Override
    public void set(byte[] copyArray) {
        this.content = (byte[])copyArray.clone();
    }

    @Override
    public boolean requiresSend() {
        boolean res = this.needsSend;
        this.needsSend = false;
        return res;
    }

    private void clearCache() {
        this.contentPropagation = null;
        this.bordersPropagation = null;
        this.isValidBorders = true;
        this.needsSend = true;
    }

    @Override
    public byte[] array() {
        if (this.content == null) {
            return new byte[0];
        }
        if (this.contentPropagation == null) {
            return this.content;
        }
        byte[] res = this.bake(this.contentPropagation, this.content);
        if (res == LightCompute.emptyContent) {
            return new byte[0];
        }
        return res;
    }

    private boolean compareBorders(byte[] a, byte[] b) {
        if (b == null && a == null) {
            return true;
        }
        if (b == null || a == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= b[i]) continue;
            return false;
        }
        return true;
    }

    private Block[] blocks() {
        Block[] blocks = new Block[4096];
        this.blockPalette.getAllPresent((x, y, z, stateId) -> {
            Block block = Block.fromStateId((short)stateId);
            assert (block != null);
            int index = x | z << 4 | y << 8;
            blocks[index] = block;
        });
        return blocks;
    }

    @Override
    public Light calculateExternal(Instance instance, Chunk chunk, int sectionY) {
        if (!this.isValidBorders) {
            this.clearCache();
        }
        Map<BlockFace, Point> neighbors = Light.getNeighbors(chunk, sectionY);
        Block[] blocks = this.blocks();
        IntArrayFIFOQueue queue = BlockLight.buildExternalQueue(instance, blocks, neighbors, this.borders);
        LightCompute.Result result = LightCompute.compute(blocks, queue);
        byte[] contentPropagationTemp = result.light();
        byte[][] borderTemp = result.borders();
        this.contentPropagationSwap = this.bake(this.contentPropagationSwap, contentPropagationTemp);
        this.bordersPropagationSwap = this.combineBorders(this.bordersPropagation, borderTemp);
        HashSet<Point> toUpdate = new HashSet<Point>();
        for (Map.Entry<BlockFace, Point> entry : neighbors.entrySet()) {
            byte[] current;
            Point neighbor = entry.getValue();
            BlockFace face = entry.getKey();
            byte[] next = borderTemp[face.ordinal()];
            if (this.compareBorders(next, current = this.getBorderPropagation(face))) continue;
            toUpdate.add(neighbor);
        }
        this.toUpdateSet = toUpdate;
        return this;
    }

    private byte[][] combineBorders(byte[][] b1, byte[][] b2) {
        if (b1 == null) {
            return b2;
        }
        byte[][] newBorder = new byte[LightCompute.FACES.length][];
        Arrays.setAll(newBorder, i -> new byte[256]);
        for (int i2 = 0; i2 < LightCompute.FACES.length; ++i2) {
            newBorder[i2] = this.combineBorders(b1[i2], b2[i2]);
        }
        return newBorder;
    }

    private byte[] bake(byte[] content1, byte[] content2) {
        if (content1 == null && content2 == null) {
            return LightCompute.emptyContent;
        }
        if (content1 == LightCompute.emptyContent && content2 == LightCompute.emptyContent) {
            return LightCompute.emptyContent;
        }
        if (content1 == null) {
            return content2;
        }
        if (content2 == null) {
            return content1;
        }
        byte[] lightMax = new byte[2048];
        for (int i = 0; i < content1.length; ++i) {
            byte l1 = (byte)(content1[i] & 0xF);
            byte l2 = (byte)(content2[i] & 0xF);
            byte u1 = (byte)(content1[i] >> 4 & 0xF);
            byte u2 = (byte)(content2[i] >> 4 & 0xF);
            byte lower = (byte)Math.max(l1, l2);
            byte upper = (byte)Math.max(u1, u2);
            lightMax[i] = (byte)(lower | upper << 4);
        }
        return lightMax;
    }

    @Override
    public byte[] getBorderPropagation(BlockFace face) {
        if (!this.isValidBorders) {
            this.clearCache();
        }
        if (this.borders == null && this.bordersPropagation == null) {
            return new byte[256];
        }
        if (this.borders == null) {
            return this.bordersPropagation[face.ordinal()];
        }
        if (this.bordersPropagation == null) {
            return this.borders[face.ordinal()];
        }
        return this.combineBorders(this.bordersPropagation[face.ordinal()], this.borders[face.ordinal()]);
    }

    @Override
    public void invalidatePropagation() {
        this.isValidBorders = false;
        this.needsSend = false;
        this.bordersPropagation = null;
        this.contentPropagation = null;
    }

    @Override
    public int getLevel(int x, int y, int z) {
        byte[] array = this.array();
        int index = x | z << 4 | y << 8;
        return LightCompute.getLight(array, index);
    }

    private byte[] combineBorders(byte[] b1, byte[] b2) {
        byte[] newBorder = new byte[256];
        for (int i = 0; i < newBorder.length; ++i) {
            byte previous = b2[i];
            byte current = b1[i];
            newBorder[i] = (byte)Math.max(previous, current);
        }
        return newBorder;
    }
}

