/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.BlockLight;
import net.minestom.server.instance.light.SkyLight;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Light {
    public static Light sky(@NotNull Palette blockPalette) {
        return new SkyLight(blockPalette);
    }

    public static Light block(@NotNull Palette blockPalette) {
        return new BlockLight(blockPalette);
    }

    public boolean requiresSend();

    @ApiStatus.Internal
    public byte[] array();

    public Set<Point> flip();

    public void copyFrom(byte @NotNull [] var1);

    @ApiStatus.Internal
    public Light calculateExternal(Instance var1, Chunk var2, int var3);

    @ApiStatus.Internal
    public byte[] getBorderPropagation(BlockFace var1);

    @ApiStatus.Internal
    public void invalidatePropagation();

    public int getLevel(int var1, int var2, int var3);

    @ApiStatus.Internal
    public Light calculateInternal(Instance var1, int var2, int var3, int var4);

    public void invalidate();

    public boolean requiresUpdate();

    public void set(byte[] var1);

    @ApiStatus.Internal
    public static Map<BlockFace, Point> getNeighbors(Chunk chunk, int sectionY) {
        int chunkX = chunk.getChunkX();
        int chunkZ = chunk.getChunkZ();
        HashMap<BlockFace, Point> links = new HashMap<BlockFace, Point>();
        for (BlockFace face : BlockFace.values()) {
            Direction direction = face.toDirection();
            int x = chunkX + direction.normalX();
            int z = chunkZ + direction.normalZ();
            int y = sectionY + direction.normalY();
            Chunk foundChunk = chunk.getInstance().getChunk(x, z);
            if (foundChunk == null || y - foundChunk.getMinSection() > foundChunk.getMaxSection() || y - foundChunk.getMinSection() < 0) continue;
            links.put(face, new Vec(foundChunk.getChunkX(), y, foundChunk.getChunkZ()));
        }
        return links;
    }
}

