/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.LinkedList;
import java.util.Objects;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.BlockLight;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.NotNull;

public final class LightCompute {
    static final BlockFace[] FACES = BlockFace.values();
    static final int LIGHT_LENGTH = 2048;
    static final int SIDE_LENGTH = 256;
    static final int SECTION_SIZE = 16;
    public static final byte[][] emptyBorders = new byte[FACES.length][256];
    public static final byte[] emptyContent = new byte[2048];

    @NotNull
    static Result compute(Palette blockPalette) {
        Block[] blocks = new Block[4096];
        return LightCompute.compute(blocks, BlockLight.buildInternalQueue(blockPalette, blocks));
    }

    @NotNull
    static Result compute(Block[] blocks, IntArrayFIFOQueue lightPre) {
        int y;
        int z;
        int x;
        int index;
        if (lightPre.isEmpty()) {
            return new Result(emptyContent, emptyBorders);
        }
        byte[][] borders = new byte[FACES.length][256];
        byte[] lightArray = new byte[2048];
        LinkedList<Integer> lightSources = new LinkedList<Integer>();
        while (!lightPre.isEmpty()) {
            index = lightPre.dequeueInt();
            x = index & 0xF;
            z = index >> 4 & 0xF;
            y = index >> 8 & 0xF;
            int newLightLevel = index >> 12 & 0xF;
            int newIndex = x | z << 4 | y << 8;
            int oldLightLevel = LightCompute.getLight(lightArray, newIndex);
            if (oldLightLevel >= newLightLevel) continue;
            LightCompute.placeLight(lightArray, newIndex, newLightLevel);
            lightSources.add(index);
        }
        while (!lightSources.isEmpty()) {
            index = (Integer)lightSources.poll();
            x = index & 0xF;
            z = index >> 4 & 0xF;
            y = index >> 8 & 0xF;
            int lightLevel = index >> 12 & 0xF;
            for (BlockFace face : FACES) {
                boolean airAir;
                Direction dir = face.toDirection();
                int xO = x + dir.normalX();
                int yO = y + dir.normalY();
                int zO = z + dir.normalZ();
                byte newLightLevel = (byte)(lightLevel - 1);
                if (xO < 0 || xO >= 16 || yO < 0 || yO >= 16 || zO < 0 || zO >= 16) {
                    byte[] border = borders[face.ordinal()];
                    int borderIndex = switch (face) {
                        default -> throw new IncompatibleClassChangeError();
                        case BlockFace.WEST, BlockFace.EAST -> y * 16 + z;
                        case BlockFace.BOTTOM, BlockFace.TOP -> x * 16 + z;
                        case BlockFace.NORTH, BlockFace.SOUTH -> x * 16 + y;
                    };
                    border[borderIndex] = newLightLevel;
                    continue;
                }
                int newIndex = xO | zO << 4 | yO << 8;
                if (LightCompute.getLight(lightArray, newIndex) + 2 > lightLevel) continue;
                Block currentBlock = Objects.requireNonNullElse(blocks[x | z << 4 | y << 8], Block.AIR);
                Block propagatedBlock = Objects.requireNonNullElse(blocks[newIndex], Block.AIR);
                boolean bl = airAir = currentBlock.isAir() && propagatedBlock.isAir();
                if (!airAir && currentBlock.registry().collisionShape().isOccluded(propagatedBlock.registry().collisionShape(), face)) continue;
                LightCompute.placeLight(lightArray, newIndex, newLightLevel);
                lightSources.add(newIndex | newLightLevel << 12);
            }
        }
        return new Result(lightArray, borders);
    }

    private static void placeLight(byte[] light, int index, int value) {
        int shift = (index & 1) << 2;
        int i = index >>> 1;
        light[i] = (byte)(light[i] & 240 >>> shift | value << shift);
    }

    static int getLight(byte[] light, int index) {
        if (index >>> 1 >= light.length) {
            return 0;
        }
        byte value = light[index >>> 1];
        return value >>> ((index & 1) << 2) & 0xF;
    }

    record Result(byte[] light, byte[][] borders) {
        Result {
            assert (light.length == 2048) : "Only 16x16x16 sections are supported: " + light.length;
        }

        public byte getLight(int x, int y, int z) {
            return (byte)LightCompute.getLight(this.light, x | z << 4 | y << 8);
        }
    }
}

