/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Collection;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.MaterialImpl;
import net.minestom.server.item.Materials;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Material
extends ProtocolObject,
Materials {
    @Contract(pure=true)
    @NotNull
    public Registry.MaterialEntry registry();

    @Override
    @NotNull
    default public NamespaceID namespace() {
        return this.registry().namespace();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public int maxStackSize() {
        return this.registry().maxStackSize();
    }

    default public boolean isFood() {
        return this.registry().isFood();
    }

    default public boolean isBlock() {
        return this.registry().block() != null;
    }

    default public Block block() {
        return this.registry().block();
    }

    default public boolean isArmor() {
        return this.registry().isArmor();
    }

    default public boolean hasState() {
        if (this == BOW || this == TRIDENT || this == CROSSBOW || this == SHIELD) {
            return true;
        }
        return this.isFood();
    }

    @NotNull
    public static @NotNull Collection<@NotNull Material> values() {
        return MaterialImpl.values();
    }

    @Nullable
    public static Material fromNamespaceId(@NotNull String namespaceID) {
        return MaterialImpl.getSafe(namespaceID);
    }

    @Nullable
    public static Material fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return Material.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static Material fromId(int id) {
        return MaterialImpl.getId(id);
    }
}

