/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public record CompassMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    private static final Tag<Boolean> LODESTONE_TRACKED = Tag.Boolean("LodestoneTracked").defaultValue(false);
    private static final Tag<String> LODESTONE_DIMENSION = Tag.String("LodestoneDimension");
    private static final Tag<Point> LODESTONE_POSITION = Tag.Structure("LodestonePos", new TagSerializer<Point>(){

        @Override
        @Nullable
        public Point read(@NotNull TagReadable reader) {
            Integer x = reader.getTag(Tag.Integer("X"));
            Integer y = reader.getTag(Tag.Integer("Y"));
            Integer z = reader.getTag(Tag.Integer("Z"));
            if (x == null || y == null || z == null) {
                return null;
            }
            return new Vec(x.intValue(), y.intValue(), z.intValue());
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull Point value) {
            writer.setTag(Tag.Integer("X"), value.blockX());
            writer.setTag(Tag.Integer("Y"), value.blockY());
            writer.setTag(Tag.Integer("Z"), value.blockZ());
        }
    });

    public boolean isLodestoneTracked() {
        return this.getTag(LODESTONE_TRACKED);
    }

    @Nullable
    public String getLodestoneDimension() {
        return this.getTag(LODESTONE_DIMENSION);
    }

    @Nullable
    public Point getLodestonePosition() {
        return this.getTag(LODESTONE_POSITION);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        public Builder lodestoneTracked(boolean lodestoneTracked) {
            this.setTag(LODESTONE_TRACKED, lodestoneTracked);
            return this;
        }

        public Builder lodestoneDimension(@Nullable String lodestoneDimension) {
            this.setTag(LODESTONE_DIMENSION, lodestoneDimension);
            return this;
        }

        public Builder lodestonePosition(@Nullable Point lodestonePosition) {
            this.setTag(LODESTONE_POSITION, lodestonePosition);
            return this;
        }
    }
}

