/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.metadata.PlayerMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.ItemUpdateStateEvent;
import net.minestom.server.event.player.PlayerStartDiggingEvent;
import net.minestom.server.event.player.PlayerSwapItemEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.StackingRule;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.server.play.AcknowledgeBlockChangePacket;
import org.jetbrains.annotations.NotNull;

public final class PlayerDiggingListener {
    public static void playerDiggingListener(ClientPlayerDiggingPacket packet, Player player) {
        ClientPlayerDiggingPacket.Status status = packet.status();
        Point blockPosition = packet.blockPosition();
        Instance instance = player.getInstance();
        if (instance == null) {
            return;
        }
        DiggingResult diggingResult = null;
        if (status == ClientPlayerDiggingPacket.Status.STARTED_DIGGING) {
            if (!instance.isChunkLoaded(blockPosition)) {
                return;
            }
            diggingResult = PlayerDiggingListener.startDigging(player, instance, blockPosition, packet.blockFace());
        } else if (status == ClientPlayerDiggingPacket.Status.CANCELLED_DIGGING) {
            if (!instance.isChunkLoaded(blockPosition)) {
                return;
            }
            diggingResult = PlayerDiggingListener.cancelDigging(instance, blockPosition);
        } else if (status == ClientPlayerDiggingPacket.Status.FINISHED_DIGGING) {
            if (!instance.isChunkLoaded(blockPosition)) {
                return;
            }
            diggingResult = PlayerDiggingListener.finishDigging(player, instance, blockPosition, packet.blockFace());
        } else if (status == ClientPlayerDiggingPacket.Status.DROP_ITEM_STACK) {
            PlayerDiggingListener.dropStack(player);
        } else if (status == ClientPlayerDiggingPacket.Status.DROP_ITEM) {
            PlayerDiggingListener.dropSingle(player);
        } else if (status == ClientPlayerDiggingPacket.Status.UPDATE_ITEM_STATE) {
            PlayerDiggingListener.updateItemState(player);
        } else if (status == ClientPlayerDiggingPacket.Status.SWAP_ITEM_HAND) {
            PlayerDiggingListener.swapItemHand(player);
        }
        if (diggingResult != null) {
            player.sendPacket(new AcknowledgeBlockChangePacket(packet.sequence()));
        }
    }

    private static DiggingResult startDigging(Player player, Instance instance, Point blockPosition, BlockFace blockFace) {
        boolean instantBreak;
        Block block = instance.getBlock(blockPosition);
        GameMode gameMode = player.getGameMode();
        if (PlayerDiggingListener.shouldPreventBreaking(player, block)) {
            return new DiggingResult(block, false);
        }
        if (gameMode == GameMode.CREATIVE) {
            return PlayerDiggingListener.breakBlock(instance, player, blockPosition, block, blockFace);
        }
        boolean bl = instantBreak = player.isInstantBreak() || block.registry().hardness() == 0.0;
        if (!instantBreak) {
            PlayerStartDiggingEvent playerStartDiggingEvent = new PlayerStartDiggingEvent(player, block, blockPosition, blockFace);
            EventDispatcher.call(playerStartDiggingEvent);
            return new DiggingResult(block, !playerStartDiggingEvent.isCancelled());
        }
        return PlayerDiggingListener.breakBlock(instance, player, blockPosition, block, blockFace);
    }

    private static DiggingResult cancelDigging(Instance instance, Point blockPosition) {
        Block block = instance.getBlock(blockPosition);
        return new DiggingResult(block, true);
    }

    private static DiggingResult finishDigging(Player player, Instance instance, Point blockPosition, BlockFace blockFace) {
        Block block = instance.getBlock(blockPosition);
        if (PlayerDiggingListener.shouldPreventBreaking(player, block)) {
            return new DiggingResult(block, false);
        }
        return PlayerDiggingListener.breakBlock(instance, player, blockPosition, block, blockFace);
    }

    private static boolean shouldPreventBreaking(@NotNull Player player, Block block) {
        ItemStack itemInMainHand;
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return true;
        }
        return player.getGameMode() == GameMode.ADVENTURE && !(itemInMainHand = player.getItemInMainHand()).meta().canDestroy(block);
    }

    private static void dropStack(Player player) {
        ItemStack droppedItemStack = player.getInventory().getItemInMainHand();
        PlayerDiggingListener.dropItem(player, droppedItemStack, ItemStack.AIR);
    }

    private static void dropSingle(Player player) {
        ItemStack handItem = player.getInventory().getItemInMainHand();
        StackingRule stackingRule = StackingRule.get();
        int handAmount = stackingRule.getAmount(handItem);
        if (handAmount <= 1) {
            PlayerDiggingListener.dropItem(player, handItem, ItemStack.AIR);
        } else {
            PlayerDiggingListener.dropItem(player, stackingRule.apply(handItem, 1), stackingRule.apply(handItem, handAmount - 1));
        }
    }

    private static void updateItemState(Player player) {
        PlayerMeta meta = player.getEntityMeta();
        if (!meta.isHandActive()) {
            return;
        }
        Player.Hand hand = meta.getActiveHand();
        player.refreshEating(null);
        player.triggerStatus((byte)9);
        ItemUpdateStateEvent itemUpdateStateEvent = player.callItemUpdateStateEvent(hand);
        if (itemUpdateStateEvent == null) {
            player.refreshActiveHand(true, false, false);
        } else {
            boolean isOffHand = itemUpdateStateEvent.getHand() == Player.Hand.OFF;
            player.refreshActiveHand(itemUpdateStateEvent.hasHandAnimation(), isOffHand, false);
        }
    }

    private static void swapItemHand(Player player) {
        PlayerInventory inventory = player.getInventory();
        ItemStack mainHand = inventory.getItemInMainHand();
        ItemStack offHand = inventory.getItemInOffHand();
        PlayerSwapItemEvent swapItemEvent = new PlayerSwapItemEvent(player, offHand, mainHand);
        EventDispatcher.callCancellable(swapItemEvent, () -> {
            inventory.setItemInMainHand(swapItemEvent.getMainHandItem());
            inventory.setItemInOffHand(swapItemEvent.getOffHandItem());
        });
    }

    private static DiggingResult breakBlock(Instance instance, Player player, Point blockPosition, Block previousBlock, BlockFace blockFace) {
        Pos playerPosition;
        boolean success = instance.breakBlock(player, blockPosition, blockFace);
        Block updatedBlock = instance.getBlock(blockPosition);
        if (!success && previousBlock.isSolid() && (playerPosition = player.getPosition()).sub(0.0, 1.0, 0.0).samePoint(blockPosition)) {
            player.teleport(playerPosition);
        }
        return new DiggingResult(updatedBlock, success);
    }

    private static void dropItem(@NotNull Player player, @NotNull ItemStack droppedItem, @NotNull ItemStack handItem) {
        PlayerInventory playerInventory = player.getInventory();
        if (player.dropItem(droppedItem)) {
            playerInventory.setItemInMainHand(handItem);
        } else {
            playerInventory.update();
        }
    }

    private record DiggingResult(Block block, boolean success) {
    }
}

