/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.map;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minestom.server.MinecraftServer;

public final class MapColors
extends Enum<MapColors> {
    public static final /* enum */ MapColors NONE;
    public static final /* enum */ MapColors GRASS;
    public static final /* enum */ MapColors SAND;
    public static final /* enum */ MapColors WOOL;
    public static final /* enum */ MapColors FIRE;
    public static final /* enum */ MapColors ICE;
    public static final /* enum */ MapColors METAL;
    public static final /* enum */ MapColors PLANT;
    public static final /* enum */ MapColors SNOW;
    public static final /* enum */ MapColors CLAY;
    public static final /* enum */ MapColors DIRT;
    public static final /* enum */ MapColors STONE;
    public static final /* enum */ MapColors WATER;
    public static final /* enum */ MapColors WOOD;
    public static final /* enum */ MapColors QUARTZ;
    public static final /* enum */ MapColors COLOR_ORANGE;
    public static final /* enum */ MapColors COLOR_MAGENTA;
    public static final /* enum */ MapColors COLOR_LIGHT_BLUE;
    public static final /* enum */ MapColors COLOR_YELLOW;
    public static final /* enum */ MapColors COLOR_LIGHT_GREEN;
    public static final /* enum */ MapColors COLOR_PINK;
    public static final /* enum */ MapColors COLOR_GRAY;
    public static final /* enum */ MapColors COLOR_LIGHT_GRAY;
    public static final /* enum */ MapColors COLOR_CYAN;
    public static final /* enum */ MapColors COLOR_PURPLE;
    public static final /* enum */ MapColors COLOR_BLUE;
    public static final /* enum */ MapColors COLOR_BROWN;
    public static final /* enum */ MapColors COLOR_GREEN;
    public static final /* enum */ MapColors COLOR_RED;
    public static final /* enum */ MapColors COLOR_BLACK;
    public static final /* enum */ MapColors GOLD;
    public static final /* enum */ MapColors DIAMOND;
    public static final /* enum */ MapColors LAPIS;
    public static final /* enum */ MapColors EMERALD;
    public static final /* enum */ MapColors PODZOL;
    public static final /* enum */ MapColors NETHER;
    public static final /* enum */ MapColors TERRACOTTA_WHITE;
    public static final /* enum */ MapColors TERRACOTTA_ORANGE;
    public static final /* enum */ MapColors TERRACOTTA_MAGENTA;
    public static final /* enum */ MapColors TERRACOTTA_LIGHT_BLUE;
    public static final /* enum */ MapColors TERRACOTTA_YELLOW;
    public static final /* enum */ MapColors TERRACOTTA_LIGHT_GREEN;
    public static final /* enum */ MapColors TERRACOTTA_PINK;
    public static final /* enum */ MapColors TERRACOTTA_GRAY;
    public static final /* enum */ MapColors TERRACOTTA_LIGHT_GRAY;
    public static final /* enum */ MapColors TERRACOTTA_CYAN;
    public static final /* enum */ MapColors TERRACOTTA_PURPLE;
    public static final /* enum */ MapColors TERRACOTTA_BLUE;
    public static final /* enum */ MapColors TERRACOTTA_BROWN;
    public static final /* enum */ MapColors TERRACOTTA_GREEN;
    public static final /* enum */ MapColors TERRACOTTA_RED;
    public static final /* enum */ MapColors TERRACOTTA_BLACK;
    public static final /* enum */ MapColors CRIMSON_NYLIUM;
    public static final /* enum */ MapColors CRIMSON_STEM;
    public static final /* enum */ MapColors CRIMSON_HYPHAE;
    public static final /* enum */ MapColors WARPED_NYLIUM;
    public static final /* enum */ MapColors WARPED_STEM;
    public static final /* enum */ MapColors WARPED_HYPHAE;
    public static final /* enum */ MapColors WARPED_WART_BLOCK;
    private final int red;
    private final int green;
    private final int blue;
    private static final ConcurrentHashMap<Integer, PreciseMapColor> rgbMap;
    private static volatile PreciseMapColor[] rgbArray;
    private static final ColorMappingStrategy mappingStrategy;
    private static final String MAPPING_ARGUMENT = "minestom.map.rgbmapping";
    private static final String REDUCTION_ARGUMENT = "minestom.map.rgbreduction";
    private static final int colorReduction;
    private static final /* synthetic */ MapColors[] $VALUES;

    public static MapColors[] values() {
        return (MapColors[])$VALUES.clone();
    }

    public static MapColors valueOf(String name) {
        return Enum.valueOf(MapColors.class, name);
    }

    private MapColors(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public byte multiply53() {
        return (byte)((this.ordinal() << 2) + 3);
    }

    public byte multiply86() {
        return (byte)((this.ordinal() << 2) + 1);
    }

    public byte multiply71() {
        return (byte)(this.ordinal() << 2);
    }

    public byte baseColor() {
        return (byte)((this.ordinal() << 2) + 2);
    }

    public int red() {
        return this.red;
    }

    public int green() {
        return this.green;
    }

    public int blue() {
        return this.blue;
    }

    private static void fillRGBMap() {
        for (MapColors base : MapColors.values()) {
            if (base == NONE) continue;
            for (Multiplier m : Multiplier.values()) {
                PreciseMapColor preciseMapColor = new PreciseMapColor(base, m);
                int rgb = preciseMapColor.toRGB();
                if (mappingStrategy == ColorMappingStrategy.APPROXIMATE) {
                    rgb = MapColors.reduceColor(rgb);
                }
                rgbMap.put(rgb, preciseMapColor);
            }
        }
    }

    private static void fillRGBArray() {
        rgbArray = new PreciseMapColor[0x1000000];
        for (int rgb = 0; rgb <= 0xFFFFFF; ++rgb) {
            MapColors.rgbArray[rgb] = MapColors.mapColor(rgb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PreciseMapColor closestColor(int argb) {
        int noAlpha = argb & 0xFFFFFF;
        if (mappingStrategy == ColorMappingStrategy.PRECISE) {
            if (rgbArray != null) return rgbArray[noAlpha];
            Class<MapColors> clazz = MapColors.class;
            synchronized (MapColors.class) {
                if (rgbArray != null) return rgbArray[noAlpha];
                MapColors.fillRGBArray();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return rgbArray[noAlpha];
            }
        }
        if (rgbMap.isEmpty()) {
            ConcurrentHashMap<Integer, PreciseMapColor> concurrentHashMap = rgbMap;
            synchronized (concurrentHashMap) {
                if (rgbMap.isEmpty()) {
                    MapColors.fillRGBMap();
                }
            }
        }
        if (mappingStrategy != ColorMappingStrategy.APPROXIMATE) return rgbMap.computeIfAbsent(noAlpha, MapColors::mapColor);
        noAlpha = MapColors.reduceColor(noAlpha);
        return rgbMap.computeIfAbsent(noAlpha, MapColors::mapColor);
    }

    private static int reduceColor(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return (red /= colorReduction) << 16 | (green /= colorReduction) << 8 | (blue /= colorReduction);
    }

    private static PreciseMapColor mapColor(int rgb) {
        PreciseMapColor closest = null;
        int closestDistance = Integer.MAX_VALUE;
        for (MapColors base : MapColors.values()) {
            if (base == NONE) continue;
            for (Multiplier m : Multiplier.values()) {
                int blue;
                int blueKey;
                int db;
                int green;
                int greenKey;
                int dg;
                int red;
                int rgbKey = PreciseMapColor.toRGB(base, m);
                int redKey = rgbKey >> 16 & 0xFF;
                int dr = redKey - (red = rgb >> 16 & 0xFF);
                int dist = dr * dr + (dg = (greenKey = rgbKey >> 8 & 0xFF) - (green = rgb >> 8 & 0xFF)) * dg + (db = (blueKey = rgbKey & 0xFF) - (blue = rgb & 0xFF)) * db;
                if (dist >= closestDistance) continue;
                closest = new PreciseMapColor(base, m);
                closestDistance = dist;
            }
        }
        return closest;
    }

    private static /* synthetic */ MapColors[] $values() {
        return new MapColors[]{NONE, GRASS, SAND, WOOL, FIRE, ICE, METAL, PLANT, SNOW, CLAY, DIRT, STONE, WATER, WOOD, QUARTZ, COLOR_ORANGE, COLOR_MAGENTA, COLOR_LIGHT_BLUE, COLOR_YELLOW, COLOR_LIGHT_GREEN, COLOR_PINK, COLOR_GRAY, COLOR_LIGHT_GRAY, COLOR_CYAN, COLOR_PURPLE, COLOR_BLUE, COLOR_BROWN, COLOR_GREEN, COLOR_RED, COLOR_BLACK, GOLD, DIAMOND, LAPIS, EMERALD, PODZOL, NETHER, TERRACOTTA_WHITE, TERRACOTTA_ORANGE, TERRACOTTA_MAGENTA, TERRACOTTA_LIGHT_BLUE, TERRACOTTA_YELLOW, TERRACOTTA_LIGHT_GREEN, TERRACOTTA_PINK, TERRACOTTA_GRAY, TERRACOTTA_LIGHT_GRAY, TERRACOTTA_CYAN, TERRACOTTA_PURPLE, TERRACOTTA_BLUE, TERRACOTTA_BROWN, TERRACOTTA_GREEN, TERRACOTTA_RED, TERRACOTTA_BLACK, CRIMSON_NYLIUM, CRIMSON_STEM, CRIMSON_HYPHAE, WARPED_NYLIUM, WARPED_STEM, WARPED_HYPHAE, WARPED_WART_BLOCK};
    }

    static {
        ColorMappingStrategy strategy;
        NONE = new MapColors(0, 0, 0);
        GRASS = new MapColors(127, 178, 56);
        SAND = new MapColors(247, 233, 163);
        WOOL = new MapColors(199, 199, 199);
        FIRE = new MapColors(255, 0, 0);
        ICE = new MapColors(160, 160, 255);
        METAL = new MapColors(167, 167, 167);
        PLANT = new MapColors(0, 124, 0);
        SNOW = new MapColors(255, 255, 255);
        CLAY = new MapColors(164, 168, 184);
        DIRT = new MapColors(151, 109, 77);
        STONE = new MapColors(112, 112, 112);
        WATER = new MapColors(64, 64, 255);
        WOOD = new MapColors(143, 119, 72);
        QUARTZ = new MapColors(255, 252, 245);
        COLOR_ORANGE = new MapColors(216, 127, 51);
        COLOR_MAGENTA = new MapColors(178, 76, 216);
        COLOR_LIGHT_BLUE = new MapColors(102, 153, 216);
        COLOR_YELLOW = new MapColors(229, 229, 51);
        COLOR_LIGHT_GREEN = new MapColors(127, 204, 25);
        COLOR_PINK = new MapColors(242, 127, 165);
        COLOR_GRAY = new MapColors(76, 76, 76);
        COLOR_LIGHT_GRAY = new MapColors(153, 153, 153);
        COLOR_CYAN = new MapColors(76, 127, 153);
        COLOR_PURPLE = new MapColors(127, 63, 178);
        COLOR_BLUE = new MapColors(51, 76, 178);
        COLOR_BROWN = new MapColors(102, 76, 51);
        COLOR_GREEN = new MapColors(102, 127, 51);
        COLOR_RED = new MapColors(153, 51, 51);
        COLOR_BLACK = new MapColors(25, 25, 25);
        GOLD = new MapColors(250, 238, 77);
        DIAMOND = new MapColors(92, 219, 213);
        LAPIS = new MapColors(74, 128, 255);
        EMERALD = new MapColors(0, 217, 58);
        PODZOL = new MapColors(129, 86, 49);
        NETHER = new MapColors(112, 2, 0);
        TERRACOTTA_WHITE = new MapColors(209, 177, 161);
        TERRACOTTA_ORANGE = new MapColors(159, 82, 36);
        TERRACOTTA_MAGENTA = new MapColors(149, 87, 108);
        TERRACOTTA_LIGHT_BLUE = new MapColors(112, 108, 138);
        TERRACOTTA_YELLOW = new MapColors(186, 133, 36);
        TERRACOTTA_LIGHT_GREEN = new MapColors(103, 117, 53);
        TERRACOTTA_PINK = new MapColors(160, 77, 78);
        TERRACOTTA_GRAY = new MapColors(57, 41, 35);
        TERRACOTTA_LIGHT_GRAY = new MapColors(135, 107, 98);
        TERRACOTTA_CYAN = new MapColors(87, 92, 92);
        TERRACOTTA_PURPLE = new MapColors(122, 73, 88);
        TERRACOTTA_BLUE = new MapColors(76, 62, 92);
        TERRACOTTA_BROWN = new MapColors(76, 50, 35);
        TERRACOTTA_GREEN = new MapColors(76, 82, 42);
        TERRACOTTA_RED = new MapColors(142, 60, 46);
        TERRACOTTA_BLACK = new MapColors(37, 22, 16);
        CRIMSON_NYLIUM = new MapColors(189, 48, 49);
        CRIMSON_STEM = new MapColors(148, 63, 97);
        CRIMSON_HYPHAE = new MapColors(92, 25, 29);
        WARPED_NYLIUM = new MapColors(22, 126, 134);
        WARPED_STEM = new MapColors(58, 142, 140);
        WARPED_HYPHAE = new MapColors(86, 44, 62);
        WARPED_WART_BLOCK = new MapColors(20, 180, 133);
        $VALUES = MapColors.$values();
        rgbMap = new ConcurrentHashMap();
        rgbArray = null;
        String strategyStr = System.getProperty(MAPPING_ARGUMENT);
        if (strategyStr == null) {
            strategy = ColorMappingStrategy.LAZY;
        } else {
            try {
                strategy = ColorMappingStrategy.valueOf(strategyStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unknown color mapping strategy: " + strategyStr);
                System.err.println("Defaulting to LAZY.");
                strategy = ColorMappingStrategy.LAZY;
            }
        }
        mappingStrategy = strategy;
        int reduction = 10;
        String reductionStr = System.getProperty(REDUCTION_ARGUMENT);
        if (reductionStr != null) {
            try {
                reduction = Integer.parseInt(reductionStr);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid integer in reduction argument: " + reductionStr);
                MinecraftServer.getExceptionManager().handleException(e);
            }
            if (reduction < 0 || reduction >= 255) {
                System.err.println("Reduction was found to be invalid: " + reduction + ". Must in 0-255, defaulting to 10.");
                reduction = 10;
            }
        }
        colorReduction = reduction;
    }

    public static enum Multiplier {
        x1_00(MapColors::baseColor, 1.0),
        x0_53(MapColors::multiply53, 0.53),
        x0_71(MapColors::multiply71, 0.71),
        x0_86(MapColors::multiply86, 0.86);

        private final Function<MapColors, Byte> indexGetter;
        private final double multiplier;

        private Multiplier(Function<MapColors, Byte> indexGetter, double multiplier) {
            this.indexGetter = indexGetter;
            this.multiplier = multiplier;
        }

        public double multiplier() {
            return this.multiplier;
        }

        public byte apply(MapColors baseColor) {
            return this.indexGetter.apply(baseColor);
        }
    }

    public static class PreciseMapColor {
        private final MapColors baseColor;
        private final Multiplier multiplier;

        PreciseMapColor(MapColors base, Multiplier multiplier) {
            this.baseColor = base;
            this.multiplier = multiplier;
        }

        public MapColors getBaseColor() {
            return this.baseColor;
        }

        public Multiplier getMultiplier() {
            return this.multiplier;
        }

        public byte getIndex() {
            return this.multiplier.apply(this.baseColor);
        }

        public int toRGB() {
            return PreciseMapColor.toRGB(this.baseColor, this.multiplier);
        }

        public static int toRGB(MapColors baseColor, Multiplier multiplier) {
            double r = baseColor.red();
            double g = baseColor.green();
            double b = baseColor.blue();
            int red = (int)(r *= multiplier.multiplier());
            int green = (int)(g *= multiplier.multiplier());
            int blue = (int)(b *= multiplier.multiplier());
            return red << 16 | green << 8 | blue;
        }
    }

    public static enum ColorMappingStrategy {
        LAZY,
        PRECISE,
        APPROXIMATE;

    }
}

