/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.metadata.animal.FrogMeta;
import net.minestom.server.entity.metadata.animal.SnifferMeta;
import net.minestom.server.entity.metadata.animal.tameable.CatMeta;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.play.data.DeathLocation;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.CompressedProcesser;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.nbt.NBTReader;
import org.jglrxavpok.hephaistos.nbt.NBTWriter;

final class NetworkBufferTypes {
    private static final int SEGMENT_BITS = 127;
    private static final int CONTINUE_BIT = 128;
    static final TypeImpl<Boolean> BOOLEAN = new TypeImpl<Boolean>(Boolean.class, (buffer, value) -> {
        buffer.ensureSize(1);
        buffer.nioBuffer.put(buffer.writeIndex(), value != false ? (byte)1 : (byte)0);
        return 1L;
    }, buffer -> {
        byte value = buffer.nioBuffer.get(buffer.readIndex());
        ++buffer.readIndex;
        return value == 1;
    });
    static final TypeImpl<Byte> BYTE = new TypeImpl<Byte>(Byte.class, (buffer, value) -> {
        buffer.ensureSize(1);
        buffer.nioBuffer.put(buffer.writeIndex(), (byte)value);
        return 1L;
    }, buffer -> {
        byte value = buffer.nioBuffer.get(buffer.readIndex());
        ++buffer.readIndex;
        return value;
    });
    static final TypeImpl<Short> SHORT = new TypeImpl<Short>(Short.class, (buffer, value) -> {
        buffer.ensureSize(2);
        buffer.nioBuffer.putShort(buffer.writeIndex(), (short)value);
        return 2L;
    }, buffer -> {
        short value = buffer.nioBuffer.getShort(buffer.readIndex());
        buffer.readIndex += 2;
        return value;
    });
    static final TypeImpl<Integer> UNSIGNED_SHORT = new TypeImpl<Integer>(Integer.class, (buffer, value) -> {
        buffer.ensureSize(2);
        buffer.nioBuffer.putShort(buffer.writeIndex(), (short)(value & 0xFFFF));
        return 2L;
    }, buffer -> {
        short value = buffer.nioBuffer.getShort(buffer.readIndex());
        buffer.readIndex += 2;
        return value & 0xFFFF;
    });
    static final TypeImpl<Integer> INT = new TypeImpl<Integer>(Integer.class, (buffer, value) -> {
        buffer.ensureSize(4);
        buffer.nioBuffer.putInt(buffer.writeIndex(), (int)value);
        return 4L;
    }, buffer -> {
        int value = buffer.nioBuffer.getInt(buffer.readIndex());
        buffer.readIndex += 4;
        return value;
    });
    static final TypeImpl<Long> LONG = new TypeImpl<Long>(Long.class, (buffer, value) -> {
        buffer.ensureSize(8);
        buffer.nioBuffer.putLong(buffer.writeIndex(), (long)value);
        return 8L;
    }, buffer -> {
        long value = buffer.nioBuffer.getLong(buffer.readIndex());
        buffer.readIndex += 8;
        return value;
    });
    static final TypeImpl<Float> FLOAT = new TypeImpl<Float>(Float.class, (buffer, value) -> {
        buffer.ensureSize(4);
        buffer.nioBuffer.putFloat(buffer.writeIndex(), value.floatValue());
        return 4L;
    }, buffer -> {
        float value = buffer.nioBuffer.getFloat(buffer.readIndex());
        buffer.readIndex += 4;
        return Float.valueOf(value);
    });
    static final TypeImpl<Double> DOUBLE = new TypeImpl<Double>(Double.class, (buffer, value) -> {
        buffer.ensureSize(8);
        buffer.nioBuffer.putDouble(buffer.writeIndex(), (double)value);
        return 8L;
    }, buffer -> {
        double value = buffer.nioBuffer.getDouble(buffer.readIndex());
        buffer.readIndex += 8;
        return value;
    });
    static final TypeImpl<Integer> VAR_INT = new TypeImpl<Integer>(Integer.class, (buffer, boxed) -> {
        int value = boxed;
        int index = buffer.writeIndex();
        if ((value & 0xFFFFFF80) == 0) {
            buffer.ensureSize(1);
            buffer.nioBuffer.put(index, (byte)value);
            return 1L;
        }
        if ((value & 0xFFFFC000) == 0) {
            buffer.ensureSize(2);
            buffer.nioBuffer.putShort(index, (short)((value & 0x7F | 0x80) << 8 | value >>> 7));
            return 2L;
        }
        if ((value & 0xFFE00000) == 0) {
            buffer.ensureSize(3);
            ByteBuffer nio = buffer.nioBuffer;
            nio.put(index, (byte)(value & 0x7F | 0x80));
            nio.put(index + 1, (byte)(value >>> 7 & 0x7F | 0x80));
            nio.put(index + 2, (byte)(value >>> 14));
            return 3L;
        }
        if ((value & 0xF0000000) == 0) {
            buffer.ensureSize(4);
            ByteBuffer nio = buffer.nioBuffer;
            nio.putInt(index, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21);
            return 4L;
        }
        buffer.ensureSize(5);
        ByteBuffer nio = buffer.nioBuffer;
        nio.putInt(index, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80));
        nio.put(index + 4, (byte)(value >>> 28));
        return 5L;
    }, buffer -> {
        int index = buffer.readIndex();
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = buffer.nioBuffer.get(index++);
            result |= (b & 0x7F) << shift;
            if (b >= 0) {
                buffer.readIndex += index - buffer.readIndex();
                return result;
            }
            shift += 7;
        }
    });
    static final TypeImpl<Long> VAR_LONG = new TypeImpl<Long>(Long.class, (buffer, value) -> {
        buffer.ensureSize(10);
        int size = 0;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.nioBuffer.put(buffer.writeIndex() + size, (byte)value.intValue());
                return size + 1;
            }
            buffer.nioBuffer.put(buffer.writeIndex() + size, (byte)(value & 0x7FL | 0x80L));
            ++size;
            value = value >>> 7;
        }
    }, buffer -> {
        long value;
        int length;
        block1: {
            length = 0;
            value = 0L;
            int position = 0;
            do {
                byte currentByte = buffer.nioBuffer.get(buffer.readIndex() + length);
                ++length;
                value |= (long)(currentByte & 0x7F) << position;
                if ((currentByte & 0x80) == 0) break block1;
            } while ((position += 7) < 64);
            throw new RuntimeException("VarLong is too big");
        }
        buffer.readIndex += length;
        return value;
    });
    static final TypeImpl<byte[]> RAW_BYTES = new TypeImpl<byte[]>(byte[].class, (buffer, value) -> {
        buffer.ensureSize(((byte[])value).length);
        buffer.nioBuffer.put(buffer.writeIndex(), (byte[])value);
        return ((byte[])value).length;
    }, buffer -> {
        int limit = buffer.nioBuffer.limit();
        int length = limit - buffer.readIndex();
        assert (length > 0) : "Invalid remaining: " + length;
        byte[] bytes = new byte[length];
        buffer.nioBuffer.get(buffer.readIndex(), bytes);
        buffer.readIndex += length;
        return bytes;
    });
    static final TypeImpl<String> STRING = new TypeImpl<String>(String.class, (buffer, value) -> {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.write(VAR_INT, bytes.length);
        buffer.write(RAW_BYTES, bytes);
        return -1L;
    }, buffer -> {
        int length = buffer.read(VAR_INT);
        byte[] bytes = new byte[length];
        buffer.nioBuffer.get(buffer.readIndex(), bytes);
        buffer.readIndex += length;
        return new String(bytes, StandardCharsets.UTF_8);
    });
    static final TypeImpl<NBT> NBT = new TypeImpl<NBT>(NBT.class, (buffer, value) -> {
        NBTWriter nbtWriter = buffer.nbtWriter;
        if (nbtWriter == null) {
            buffer.nbtWriter = nbtWriter = new NBTWriter(new OutputStream(){

                @Override
                public void write(int b) {
                    buffer.write(BYTE, (byte)b);
                }
            }, CompressedProcesser.NONE);
        }
        try {
            nbtWriter.writeNamed("", value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return -1L;
    }, buffer -> {
        NBTReader nbtReader = buffer.nbtReader;
        if (nbtReader == null) {
            buffer.nbtReader = nbtReader = new NBTReader(new InputStream(){

                @Override
                public int read() {
                    return buffer.read(BYTE) & 0xFF;
                }

                @Override
                public int available() {
                    return buffer.readableBytes();
                }
            }, CompressedProcesser.NONE);
        }
        try {
            return nbtReader.read();
        }
        catch (IOException | NBTException e) {
            throw new RuntimeException(e);
        }
    });
    static final TypeImpl<Point> BLOCK_POSITION = new TypeImpl<Point>(Point.class, (buffer, value) -> {
        int blockX = value.blockX();
        int blockY = value.blockY();
        int blockZ = value.blockZ();
        long longPos = ((long)blockX & 0x3FFFFFFL) << 38 | ((long)blockZ & 0x3FFFFFFL) << 12 | (long)blockY & 0xFFFL;
        buffer.write(LONG, longPos);
        return -1L;
    }, buffer -> {
        long value = buffer.read(LONG);
        int x = (int)(value >> 38);
        int y = (int)(value << 52 >> 52);
        int z = (int)(value << 26 >> 38);
        return new Vec(x, y, z);
    });
    static final TypeImpl<Component> COMPONENT = new TypeImpl<Component>(Component.class, (buffer, value) -> {
        String json = (String)GsonComponentSerializer.gson().serialize(value);
        buffer.write(STRING, json);
        return -1L;
    }, buffer -> {
        String json = buffer.read(STRING);
        return GsonComponentSerializer.gson().deserialize((Object)json);
    });
    static final TypeImpl<UUID> UUID = new TypeImpl<UUID>(UUID.class, (buffer, value) -> {
        buffer.write(LONG, value.getMostSignificantBits());
        buffer.write(LONG, value.getLeastSignificantBits());
        return -1L;
    }, buffer -> {
        long mostSignificantBits = buffer.read(LONG);
        long leastSignificantBits = buffer.read(LONG);
        return new UUID(mostSignificantBits, leastSignificantBits);
    });
    static final TypeImpl<ItemStack> ITEM = new TypeImpl<ItemStack>(ItemStack.class, (buffer, value) -> {
        if (value.isAir()) {
            buffer.write(BOOLEAN, false);
            return -1L;
        }
        buffer.write(BOOLEAN, true);
        buffer.write(VAR_INT, value.material().id());
        buffer.write(BYTE, (byte)value.amount());
        buffer.write(NBT, value.meta().toNBT());
        return -1L;
    }, buffer -> {
        boolean present = buffer.read(BOOLEAN);
        if (!present) {
            return ItemStack.AIR;
        }
        int id = buffer.read(VAR_INT);
        Material material = Material.fromId(id);
        if (material == null) {
            throw new RuntimeException("Unknown material id: " + id);
        }
        byte amount = buffer.read(BYTE);
        NBT nbt = buffer.read(NBT);
        if (!(nbt instanceof NBTCompound)) {
            return ItemStack.of(material, amount);
        }
        NBTCompound compound = (NBTCompound)nbt;
        return ItemStack.fromNBT(material, compound, amount);
    });
    static final TypeImpl<byte[]> BYTE_ARRAY = new TypeImpl<byte[]>(byte[].class, (buffer, value) -> {
        buffer.write(VAR_INT, ((byte[])value).length);
        buffer.write(RAW_BYTES, value);
        return -1L;
    }, buffer -> {
        int length = buffer.read(VAR_INT);
        byte[] bytes = new byte[length];
        buffer.nioBuffer.get(buffer.readIndex(), bytes);
        buffer.readIndex += length;
        return bytes;
    });
    static final TypeImpl<long[]> LONG_ARRAY = new TypeImpl<long[]>(long[].class, (buffer, value) -> {
        buffer.write(VAR_INT, ((long[])value).length);
        for (long l : value) {
            buffer.write(LONG, l);
        }
        return -1L;
    }, buffer -> {
        int length = buffer.read(VAR_INT);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = buffer.read(LONG);
        }
        return longs;
    });
    static final TypeImpl<int[]> VAR_INT_ARRAY = new TypeImpl<int[]>(int[].class, (buffer, value) -> {
        buffer.write(VAR_INT, ((int[])value).length);
        for (int i : value) {
            buffer.write(VAR_INT, i);
        }
        return -1L;
    }, buffer -> {
        int length = buffer.read(VAR_INT);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = buffer.read(VAR_INT);
        }
        return ints;
    });
    static final TypeImpl<long[]> VAR_LONG_ARRAY = new TypeImpl<long[]>(long[].class, (buffer, value) -> {
        buffer.write(VAR_INT, ((long[])value).length);
        for (long l : value) {
            buffer.write(VAR_LONG, l);
        }
        return -1L;
    }, buffer -> {
        int length = buffer.read(VAR_INT);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = buffer.read(VAR_LONG);
        }
        return longs;
    });
    static final TypeImpl<Component> OPT_CHAT = new TypeImpl<Component>(Component.class, (buffer, value) -> {
        if (value == null) {
            buffer.write(BOOLEAN, false);
            return -1L;
        }
        buffer.write(BOOLEAN, true);
        buffer.write(COMPONENT, value);
        return -1L;
    }, buffer -> {
        boolean present = buffer.read(BOOLEAN);
        if (!present) {
            return null;
        }
        return buffer.read(COMPONENT);
    });
    static final TypeImpl<Point> ROTATION = new TypeImpl<Point>(Point.class, (buffer, value) -> {
        buffer.write(FLOAT, Float.valueOf((float)value.x()));
        buffer.write(FLOAT, Float.valueOf((float)value.y()));
        buffer.write(FLOAT, Float.valueOf((float)value.z()));
        return -1L;
    }, buffer -> {
        float x = buffer.read(FLOAT).floatValue();
        float y = buffer.read(FLOAT).floatValue();
        float z = buffer.read(FLOAT).floatValue();
        return new Vec(x, y, z);
    });
    static final TypeImpl<Point> OPT_BLOCK_POSITION = new TypeImpl<Point>(Point.class, (buffer, value) -> {
        if (value == null) {
            buffer.write(BOOLEAN, false);
            return -1L;
        }
        buffer.write(BOOLEAN, true);
        buffer.write(BLOCK_POSITION, value);
        return -1L;
    }, buffer -> {
        boolean present = buffer.read(BOOLEAN);
        if (!present) {
            return null;
        }
        return buffer.read(BLOCK_POSITION);
    });
    static final TypeImpl<Direction> DIRECTION = new TypeImpl<Direction>(Direction.class, (buffer, value) -> {
        buffer.write(VAR_INT, value.ordinal());
        return -1L;
    }, buffer -> {
        int ordinal = buffer.read(VAR_INT);
        return Direction.values()[ordinal];
    });
    static final TypeImpl<UUID> OPT_UUID = new TypeImpl<UUID>(UUID.class, (buffer, value) -> {
        if (value == null) {
            buffer.write(BOOLEAN, false);
            return -1L;
        }
        buffer.write(BOOLEAN, true);
        buffer.write(UUID, value);
        return -1L;
    }, buffer -> {
        boolean present = buffer.read(BOOLEAN);
        if (!present) {
            return null;
        }
        return buffer.read(UUID);
    });
    static final TypeImpl<Integer> BLOCK_STATE = new TypeImpl<Integer>(Integer.class, (buffer, value) -> {
        buffer.write(NetworkBuffer.VAR_INT, value);
        return -1L;
    }, buffer -> buffer.read(VAR_INT));
    static final TypeImpl<Integer> OPT_BLOCK_STATE = new TypeImpl<Integer>(Integer.class, (buffer, value) -> {
        if (value == null) {
            buffer.write(NetworkBuffer.VAR_INT, 0);
            return -1L;
        }
        buffer.write(VAR_INT, value);
        return -1L;
    }, buffer -> {
        int value = buffer.read(VAR_INT);
        return value == 0 ? null : Integer.valueOf(value);
    });
    static final TypeImpl<int[]> VILLAGER_DATA = new TypeImpl<int[]>(int[].class, (buffer, value) -> {
        buffer.write(VAR_INT, value[0]);
        buffer.write(VAR_INT, value[1]);
        buffer.write(VAR_INT, value[2]);
        return -1L;
    }, buffer -> {
        int[] value = new int[]{buffer.read(VAR_INT), buffer.read(VAR_INT), buffer.read(VAR_INT)};
        return value;
    });
    static final TypeImpl<Integer> OPT_VAR_INT = new TypeImpl<Integer>(Integer.TYPE, (buffer, value) -> {
        if (value == null) {
            buffer.write(VAR_INT, 0);
            return -1L;
        }
        buffer.write(VAR_INT, value + 1);
        return -1L;
    }, buffer -> {
        int value = buffer.read(VAR_INT);
        return value == 0 ? null : Integer.valueOf(value - 1);
    });
    static final TypeImpl<Entity.Pose> POSE = new TypeImpl<Entity.Pose>(Entity.Pose.class, (buffer, value) -> {
        buffer.write(VAR_INT, value.ordinal());
        return -1L;
    }, buffer -> {
        int ordinal = buffer.read(VAR_INT);
        return Entity.Pose.values()[ordinal];
    });
    static final TypeImpl<DeathLocation> DEATH_LOCATION = new TypeImpl<DeathLocation>(DeathLocation.class, (buffer, value) -> {
        if (value == null) {
            buffer.write(BOOLEAN, false);
        } else {
            buffer.write(BOOLEAN, true);
            buffer.write(STRING, value.dimension());
            buffer.write(BLOCK_POSITION, value.position());
        }
        return -1L;
    }, buffer -> {
        if (buffer.read(BOOLEAN).booleanValue()) {
            return new DeathLocation(buffer.read(STRING), buffer.read(BLOCK_POSITION));
        }
        return null;
    });
    static final TypeImpl<CatMeta.Variant> CAT_VARIANT = new TypeImpl<CatMeta.Variant>(CatMeta.Variant.class, (buffer, value) -> {
        buffer.write(VAR_INT, value.ordinal());
        return -1L;
    }, buffer -> {
        int ordinal = buffer.read(VAR_INT);
        return CatMeta.Variant.values()[ordinal];
    });
    static final TypeImpl<FrogMeta.Variant> FROG_VARIANT = new TypeImpl<FrogMeta.Variant>(FrogMeta.Variant.class, (buffer, value) -> {
        buffer.write(VAR_INT, value.ordinal());
        return -1L;
    }, buffer -> {
        int ordinal = buffer.read(VAR_INT);
        return FrogMeta.Variant.values()[ordinal];
    });
    static final TypeImpl<SnifferMeta.State> SNIFFER_STATE = new TypeImpl<SnifferMeta.State>(SnifferMeta.State.class, (buffer, value) -> {
        buffer.write(VAR_INT, value.ordinal());
        return -1L;
    }, buffer -> {
        int ordinal = buffer.read(VAR_INT);
        return SnifferMeta.State.values()[ordinal];
    });
    static final TypeImpl<Point> VECTOR3 = new TypeImpl<Point>(Point.class, (buffer, value) -> {
        buffer.write(FLOAT, Float.valueOf((float)value.x()));
        buffer.write(FLOAT, Float.valueOf((float)value.y()));
        buffer.write(FLOAT, Float.valueOf((float)value.z()));
        return -1L;
    }, buffer -> {
        float x = buffer.read(FLOAT).floatValue();
        float y = buffer.read(FLOAT).floatValue();
        float z = buffer.read(FLOAT).floatValue();
        return new Vec(x, y, z);
    });
    static final TypeImpl<Point> VECTOR3D = new TypeImpl<Point>(Point.class, (buffer, value) -> {
        buffer.write(DOUBLE, value.x());
        buffer.write(DOUBLE, value.y());
        buffer.write(DOUBLE, value.z());
        return -1L;
    }, buffer -> {
        double x = buffer.read(DOUBLE);
        double y = buffer.read(DOUBLE);
        double z = buffer.read(DOUBLE);
        return new Vec(x, y, z);
    });
    static final TypeImpl<float[]> QUATERNION = new TypeImpl<float[]>(float[].class, (buffer, value) -> {
        buffer.write(FLOAT, Float.valueOf(value[0]));
        buffer.write(FLOAT, Float.valueOf(value[1]));
        buffer.write(FLOAT, Float.valueOf(value[2]));
        buffer.write(FLOAT, Float.valueOf(value[3]));
        return -1L;
    }, buffer -> {
        float x = buffer.read(FLOAT).floatValue();
        float y = buffer.read(FLOAT).floatValue();
        float z = buffer.read(FLOAT).floatValue();
        float w = buffer.read(FLOAT).floatValue();
        return new float[]{x, y, z, w};
    });

    NetworkBufferTypes() {
    }

    record TypeImpl<T>(@NotNull Class<T> type, @NotNull TypeWriter<T> writer, @NotNull TypeReader<T> reader) implements NetworkBuffer.Type<T>
    {
    }

    static interface TypeWriter<T> {
        public long write(@NotNull NetworkBuffer var1, @UnknownNullability T var2);
    }

    static interface TypeReader<T> {
        public @UnknownNullability T read(@NotNull NetworkBuffer var1);
    }
}

