/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client;

import java.util.function.Function;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.login.EncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.LoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.LoginStartPacket;
import net.minestom.server.network.packet.client.play.ClientAdvancementTabPacket;
import net.minestom.server.network.packet.client.play.ClientAnimationPacket;
import net.minestom.server.network.packet.client.play.ClientChatAckPacket;
import net.minestom.server.network.packet.client.play.ClientChatMessagePacket;
import net.minestom.server.network.packet.client.play.ClientChatSessionUpdatePacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowButtonPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCommandChatPacket;
import net.minestom.server.network.packet.client.play.ClientCraftRecipeRequest;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.network.packet.client.play.ClientEditBookPacket;
import net.minestom.server.network.packet.client.play.ClientEntityActionPacket;
import net.minestom.server.network.packet.client.play.ClientGenerateStructurePacket;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;
import net.minestom.server.network.packet.client.play.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.play.ClientNameItemPacket;
import net.minestom.server.network.packet.client.play.ClientPickItemPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerAbilitiesPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerBlockPlacementPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionAndRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPluginMessagePacket;
import net.minestom.server.network.packet.client.play.ClientPongPacket;
import net.minestom.server.network.packet.client.play.ClientQueryBlockNbtPacket;
import net.minestom.server.network.packet.client.play.ClientQueryEntityNbtPacket;
import net.minestom.server.network.packet.client.play.ClientResourcePackStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSelectTradePacket;
import net.minestom.server.network.packet.client.play.ClientSetBeaconEffectPacket;
import net.minestom.server.network.packet.client.play.ClientSetDisplayedRecipePacket;
import net.minestom.server.network.packet.client.play.ClientSetRecipeBookStatePacket;
import net.minestom.server.network.packet.client.play.ClientSettingsPacket;
import net.minestom.server.network.packet.client.play.ClientSpectatePacket;
import net.minestom.server.network.packet.client.play.ClientStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSteerBoatPacket;
import net.minestom.server.network.packet.client.play.ClientSteerVehiclePacket;
import net.minestom.server.network.packet.client.play.ClientTabCompletePacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockMinecartPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateSignPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateStructureBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.client.play.ClientVehicleMovePacket;
import net.minestom.server.network.packet.client.status.PingPacket;
import net.minestom.server.network.packet.client.status.StatusRequestPacket;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ClientPacketsHandler {
    private final ObjectArray<Function<NetworkBuffer, ClientPacket>> suppliers = ObjectArray.singleThread(16);

    private ClientPacketsHandler() {
    }

    public void register(int id, @NotNull @NotNull Function<@NotNull NetworkBuffer, @NotNull ClientPacket> packetSupplier) {
        this.suppliers.set(id, packetSupplier);
    }

    public @UnknownNullability ClientPacket create(int packetId, @NotNull NetworkBuffer reader) {
        Function<NetworkBuffer, ClientPacket> supplier = this.suppliers.get(packetId);
        if (supplier == null) {
            throw new IllegalStateException("Packet id 0x" + Integer.toHexString(packetId) + " isn't registered!");
        }
        return supplier.apply(reader);
    }

    public static final class Play
    extends ClientPacketsHandler {
        private static int nextId = 0;

        private static int nextPlayId() {
            return nextId++;
        }

        public Play() {
            this.register(Play.nextPlayId(), ClientTeleportConfirmPacket::new);
            this.register(Play.nextPlayId(), ClientQueryBlockNbtPacket::new);
            Play.nextPlayId();
            this.register(Play.nextPlayId(), ClientChatAckPacket::new);
            this.register(Play.nextPlayId(), ClientCommandChatPacket::new);
            this.register(Play.nextPlayId(), ClientChatMessagePacket::new);
            this.register(Play.nextPlayId(), ClientChatSessionUpdatePacket::new);
            this.register(Play.nextPlayId(), ClientStatusPacket::new);
            this.register(Play.nextPlayId(), ClientSettingsPacket::new);
            this.register(Play.nextPlayId(), ClientTabCompletePacket::new);
            this.register(Play.nextPlayId(), ClientClickWindowButtonPacket::new);
            this.register(Play.nextPlayId(), ClientClickWindowPacket::new);
            this.register(Play.nextPlayId(), ClientCloseWindowPacket::new);
            this.register(Play.nextPlayId(), ClientPluginMessagePacket::new);
            this.register(Play.nextPlayId(), ClientEditBookPacket::new);
            this.register(Play.nextPlayId(), ClientQueryEntityNbtPacket::new);
            this.register(Play.nextPlayId(), ClientInteractEntityPacket::new);
            this.register(Play.nextPlayId(), ClientGenerateStructurePacket::new);
            this.register(Play.nextPlayId(), ClientKeepAlivePacket::new);
            Play.nextPlayId();
            this.register(Play.nextPlayId(), ClientPlayerPositionPacket::new);
            this.register(Play.nextPlayId(), ClientPlayerPositionAndRotationPacket::new);
            this.register(Play.nextPlayId(), ClientPlayerRotationPacket::new);
            this.register(Play.nextPlayId(), ClientPlayerPacket::new);
            this.register(Play.nextPlayId(), ClientVehicleMovePacket::new);
            this.register(Play.nextPlayId(), ClientSteerBoatPacket::new);
            this.register(Play.nextPlayId(), ClientPickItemPacket::new);
            this.register(Play.nextPlayId(), ClientCraftRecipeRequest::new);
            this.register(Play.nextPlayId(), ClientPlayerAbilitiesPacket::new);
            this.register(Play.nextPlayId(), ClientPlayerDiggingPacket::new);
            this.register(Play.nextPlayId(), ClientEntityActionPacket::new);
            this.register(Play.nextPlayId(), ClientSteerVehiclePacket::new);
            this.register(Play.nextPlayId(), ClientPongPacket::new);
            this.register(Play.nextPlayId(), ClientSetRecipeBookStatePacket::new);
            this.register(Play.nextPlayId(), ClientSetDisplayedRecipePacket::new);
            this.register(Play.nextPlayId(), ClientNameItemPacket::new);
            this.register(Play.nextPlayId(), ClientResourcePackStatusPacket::new);
            this.register(Play.nextPlayId(), ClientAdvancementTabPacket::new);
            this.register(Play.nextPlayId(), ClientSelectTradePacket::new);
            this.register(Play.nextPlayId(), ClientSetBeaconEffectPacket::new);
            this.register(Play.nextPlayId(), ClientHeldItemChangePacket::new);
            this.register(Play.nextPlayId(), ClientUpdateCommandBlockPacket::new);
            this.register(Play.nextPlayId(), ClientUpdateCommandBlockMinecartPacket::new);
            this.register(Play.nextPlayId(), ClientCreativeInventoryActionPacket::new);
            Play.nextPlayId();
            this.register(Play.nextPlayId(), ClientUpdateStructureBlockPacket::new);
            this.register(Play.nextPlayId(), ClientUpdateSignPacket::new);
            this.register(Play.nextPlayId(), ClientAnimationPacket::new);
            this.register(Play.nextPlayId(), ClientSpectatePacket::new);
            this.register(Play.nextPlayId(), ClientPlayerBlockPlacementPacket::new);
            this.register(Play.nextPlayId(), ClientUseItemPacket::new);
        }
    }

    public static final class Login
    extends ClientPacketsHandler {
        public Login() {
            this.register(0, LoginStartPacket::new);
            this.register(1, EncryptionResponsePacket::new);
            this.register(2, LoginPluginResponsePacket::new);
        }
    }

    public static final class Status
    extends ClientPacketsHandler {
        public Status() {
            this.register(0, StatusRequestPacket::new);
            this.register(1, PingPacket::new);
        }
    }
}

