/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.handshake;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPreplayPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record HandshakePacket(int protocolVersion, @NotNull String serverAddress, int serverPort, int nextState) implements ClientPreplayPacket
{
    private static final Logger LOGGER = LoggerFactory.getLogger(HandshakePacket.class);
    private static final Component INVALID_VERSION_TEXT = Component.text((String)"Invalid Version, please use 1.20.1", (TextColor)NamedTextColor.RED);
    private static final Component INVALID_BUNGEE_FORWARDING = Component.text((String)"Invalid connection, please connect through the BungeeCord proxy. If you believe this is an error, contact a server administrator.", (TextColor)NamedTextColor.RED);

    public HandshakePacket(int protocolVersion, @NotNull String serverAddress, int serverPort, int nextState) {
        if (serverAddress.length() > HandshakePacket.getMaxHandshakeLength()) {
            throw new IllegalArgumentException("Server address too long: " + serverAddress.length());
        }
    }

    public HandshakePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.UNSIGNED_SHORT), reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.protocolVersion);
        int maxLength = HandshakePacket.getMaxHandshakeLength();
        if (this.serverAddress.length() > maxLength) {
            throw new IllegalArgumentException("serverAddress is " + this.serverAddress.length() + " characters long, maximum allowed is " + maxLength);
        }
        writer.write(NetworkBuffer.STRING, this.serverAddress);
        writer.write(NetworkBuffer.UNSIGNED_SHORT, this.serverPort);
        writer.write(NetworkBuffer.VAR_INT, this.nextState);
    }

    @Override
    public void process(@NotNull PlayerConnection connection) {
        String address = this.serverAddress;
        if (BungeeCordProxy.isEnabled() && connection instanceof PlayerSocketConnection) {
            PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
            if (this.nextState == 2) {
                String[] split = address.split("\u0000");
                if (split.length == 3 || split.length == 4) {
                    boolean hasProperties;
                    boolean bl = hasProperties = split.length == 4;
                    if (BungeeCordProxy.isBungeeGuardEnabled() && !hasProperties) {
                        this.bungeeDisconnect(socketConnection);
                        return;
                    }
                    address = split[0];
                    InetSocketAddress socketAddress = new InetSocketAddress(split[1], ((InetSocketAddress)connection.getRemoteAddress()).getPort());
                    socketConnection.setRemoteAddress(socketAddress);
                    UUID playerUuid = UUID.fromString(split[2].replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
                    ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>();
                    if (hasProperties) {
                        boolean foundBungeeGuardToken = false;
                        String rawPropertyJson = split[3];
                        JsonArray propertyJson = JsonParser.parseString((String)rawPropertyJson).getAsJsonArray();
                        for (JsonElement element : propertyJson) {
                            String signatureString;
                            JsonObject jsonObject = element.getAsJsonObject();
                            JsonElement name = jsonObject.get("name");
                            JsonElement value = jsonObject.get("value");
                            JsonElement signature = jsonObject.get("signature");
                            if (name == null || value == null) continue;
                            String nameString = name.getAsString();
                            String valueString = value.getAsString();
                            String string = signatureString = signature == null ? null : signature.getAsString();
                            if (BungeeCordProxy.isBungeeGuardEnabled() && nameString.equals("bungeeguard-token")) {
                                if (foundBungeeGuardToken || !BungeeCordProxy.isValidBungeeGuardToken(valueString)) {
                                    this.bungeeDisconnect(socketConnection);
                                    return;
                                }
                                foundBungeeGuardToken = true;
                            }
                            properties.add(new GameProfile.Property(nameString, valueString, signatureString));
                        }
                        if (BungeeCordProxy.isBungeeGuardEnabled() && !foundBungeeGuardToken) {
                            this.bungeeDisconnect(socketConnection);
                            return;
                        }
                    }
                    GameProfile gameProfile = new GameProfile(playerUuid, "test", properties);
                    socketConnection.UNSAFE_setProfile(gameProfile);
                } else {
                    this.bungeeDisconnect(socketConnection);
                    return;
                }
            }
        }
        if (connection instanceof PlayerSocketConnection) {
            ((PlayerSocketConnection)connection).refreshServerInformation(address, this.serverPort, this.protocolVersion);
        }
        switch (this.nextState) {
            case 1: {
                connection.setConnectionState(ConnectionState.STATUS);
                break;
            }
            case 2: {
                if (this.protocolVersion == 763) {
                    connection.setConnectionState(ConnectionState.LOGIN);
                    break;
                }
                this.disconnect(connection, INVALID_VERSION_TEXT);
                break;
            }
        }
    }

    private static int getMaxHandshakeLength() {
        return BungeeCordProxy.isEnabled() ? (BungeeCordProxy.isBungeeGuardEnabled() ? 2500 : Short.MAX_VALUE) : 255;
    }

    private void disconnect(@NotNull PlayerConnection connection, @NotNull Component reason) {
        connection.sendPacket(new LoginDisconnectPacket(reason));
        connection.disconnect();
    }

    private void bungeeDisconnect(@NotNull PlayerConnection connection) {
        LOGGER.warn("{} tried to log in without valid BungeeGuard forwarding information.", (Object)connection.getIdentifier());
        this.disconnect(connection, INVALID_BUNGEE_FORWARDING);
    }
}

