/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.login;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.SecretKey;
import net.minestom.server.MinecraftServer;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPreplayPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.utils.async.AsyncUtils;
import org.jetbrains.annotations.NotNull;

public record EncryptionResponsePacket(byte[] sharedSecret, byte[] encryptedVerifyToken) implements ClientPreplayPacket
{
    private static final Gson GSON = new Gson();

    public EncryptionResponsePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BYTE_ARRAY), reader.read(NetworkBuffer.BYTE_ARRAY));
    }

    @Override
    public void process(@NotNull PlayerConnection connection) {
        if (!(connection instanceof PlayerSocketConnection)) {
            return;
        }
        PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
        AsyncUtils.runAsync(() -> {
            boolean verificationFailed;
            String loginUsername = socketConnection.getLoginUsername();
            if (loginUsername == null || loginUsername.isEmpty()) {
                return;
            }
            boolean hasPublicKey = connection.playerPublicKey() != null;
            boolean bl = verificationFailed = hasPublicKey || !Arrays.equals(socketConnection.getNonce(), MojangCrypt.decryptUsingKey(MojangAuth.getKeyPair().getPrivate(), this.encryptedVerifyToken));
            if (verificationFailed) {
                MinecraftServer.LOGGER.error("Encryption failed for {}", (Object)loginUsername);
                return;
            }
            byte[] digestedData = MojangCrypt.digestData("", MojangAuth.getKeyPair().getPublic(), this.getSecretKey());
            if (digestedData == null) {
                MinecraftServer.LOGGER.error("Connection {} failed initializing encryption.", (Object)socketConnection.getRemoteAddress());
                connection.disconnect();
                return;
            }
            String serverId = new BigInteger(digestedData).toString(16);
            String username = URLEncoder.encode(loginUsername, StandardCharsets.UTF_8);
            String url = String.format(MojangAuth.AUTH_URL, username, serverId);
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create(url)).GET().build();
            client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    MinecraftServer.getExceptionManager().handleException((Throwable)throwable);
                    return;
                }
                try {
                    JsonObject gameProfile = (JsonObject)GSON.fromJson((String)response.body(), JsonObject.class);
                    if (gameProfile == null) {
                        return;
                    }
                    socketConnection.setEncryptionKey(this.getSecretKey());
                    UUID profileUUID = UUID.fromString(gameProfile.get("id").getAsString().replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                    String profileName = gameProfile.get("name").getAsString();
                    MinecraftServer.LOGGER.info("UUID of player {} is {}", (Object)loginUsername, (Object)profileUUID);
                    CONNECTION_MANAGER.startPlayState(connection, profileUUID, profileName, true);
                }
                catch (Exception e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            });
        });
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE_ARRAY, this.sharedSecret);
        writer.write(NetworkBuffer.BYTE_ARRAY, this.encryptedVerifyToken);
    }

    private SecretKey getSecretKey() {
        return MojangCrypt.decryptByteToSecretKey(MojangAuth.getKeyPair().getPrivate(), this.sharedSecret);
    }
}

