/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.login;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.extras.velocity.VelocityProxy;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPreplayPacket;
import net.minestom.server.network.packet.server.login.EncryptionRequestPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.packet.server.login.LoginPluginRequestPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LoginStartPacket(@NotNull String username, @Nullable UUID profileId) implements ClientPreplayPacket
{
    private static final Component ALREADY_CONNECTED = Component.text((String)"You are already on this server", (TextColor)NamedTextColor.RED);

    public LoginStartPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.readOptional(NetworkBuffer.UUID));
    }

    @Override
    public void process(@NotNull PlayerConnection connection) {
        PlayerSocketConnection socketConnection;
        boolean isSocketConnection = connection instanceof PlayerSocketConnection;
        if (isSocketConnection) {
            socketConnection = (PlayerSocketConnection)connection;
            socketConnection.UNSAFE_setLoginUsername(this.username);
            if (VelocityProxy.isEnabled()) {
                int messageId = ThreadLocalRandom.current().nextInt();
                String channel = "velocity:player_info";
                socketConnection.addPluginRequestEntry(messageId, "velocity:player_info");
                connection.sendPacket(new LoginPluginRequestPacket(messageId, "velocity:player_info", null));
                return;
            }
        }
        if (MojangAuth.isEnabled() && isSocketConnection) {
            if (CONNECTION_MANAGER.getPlayer(this.username) != null) {
                connection.sendPacket(new LoginDisconnectPacket(ALREADY_CONNECTED));
                connection.disconnect();
                return;
            }
            socketConnection = (PlayerSocketConnection)connection;
            socketConnection.setConnectionState(ConnectionState.LOGIN);
            byte[] publicKey = MojangAuth.getKeyPair().getPublic().getEncoded();
            byte[] nonce = new byte[4];
            ThreadLocalRandom.current().nextBytes(nonce);
            socketConnection.setNonce(nonce);
            socketConnection.sendPacket(new EncryptionRequestPacket("", publicKey, nonce));
        } else {
            boolean bungee = BungeeCordProxy.isEnabled();
            UUID playerUuid = bungee && isSocketConnection ? ((PlayerSocketConnection)connection).gameProfile().uuid() : CONNECTION_MANAGER.getPlayerConnectionUuid(connection, this.username);
            CONNECTION_MANAGER.startPlayState(connection, playerUuid, this.username, true);
        }
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        if (this.username.length() > 16) {
            throw new IllegalArgumentException("Username is not allowed to be longer than 16 characters");
        }
        writer.write(NetworkBuffer.STRING, this.username);
    }
}

