/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Metadata;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntityMetaDataPacket(int entityId, @NotNull Map<Integer, Metadata.Entry<?>> entries) implements ComponentHoldingServerPacket
{
    public EntityMetaDataPacket(int entityId, @NotNull Map<Integer, Metadata.Entry<?>> entries) {
        entries = Map.copyOf(entries);
    }

    public EntityMetaDataPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), EntityMetaDataPacket.readEntries(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        for (Map.Entry<Integer, Metadata.Entry<?>> entry : this.entries.entrySet()) {
            writer.write(NetworkBuffer.BYTE, entry.getKey().byteValue());
            writer.write(entry.getValue());
        }
        writer.write(NetworkBuffer.BYTE, (byte)-1);
    }

    private static Map<Integer, Metadata.Entry<?>> readEntries(@NotNull NetworkBuffer reader) {
        byte index;
        HashMap entries = new HashMap();
        while ((index = reader.read(NetworkBuffer.BYTE).byteValue()) != -1) {
            int type = reader.read(NetworkBuffer.VAR_INT);
            entries.put(Integer.valueOf(index), Metadata.Entry.read(type, reader));
        }
        return entries;
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.ENTITY_METADATA;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return this.entries.values().stream().map(Metadata.Entry::value).filter(entry -> entry instanceof Component).map(entry -> (Component)entry).toList();
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        HashMap entries = new HashMap();
        this.entries.forEach((key, value) -> {
            Metadata.Entry<Component> entry;
            Object v = value.value();
            if (v instanceof Component) {
                Component c = (Component)v;
                entry = Metadata.OptChat((Component)operator.apply(c));
            } else {
                entry = value;
            }
            entries.put((Integer)key, entry);
        });
        return new EntityMetaDataPacket(this.entityId, entries);
    }
}

