/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record FacePlayerPacket(FacePosition facePosition, Point target, int entityId, FacePosition entityFacePosition) implements ServerPacket
{
    public FacePlayerPacket(@NotNull NetworkBuffer reader) {
        this(FacePosition.values()[reader.read(NetworkBuffer.VAR_INT)], new Vec(reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE)), reader.read(NetworkBuffer.BOOLEAN) != false ? reader.read(NetworkBuffer.VAR_INT) : 0, reader.readableBytes() > 0 ? reader.readEnum(FacePosition.class) : null);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.facePosition.ordinal());
        writer.write(NetworkBuffer.DOUBLE, this.target.x());
        writer.write(NetworkBuffer.DOUBLE, this.target.y());
        writer.write(NetworkBuffer.DOUBLE, this.target.z());
        boolean isEntity = this.entityId > 0;
        writer.write(NetworkBuffer.BOOLEAN, isEntity);
        if (isEntity) {
            writer.write(NetworkBuffer.VAR_INT, this.entityId);
            writer.writeEnum(FacePosition.class, this.entityFacePosition);
        }
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.FACE_PLAYER;
    }

    public static enum FacePosition {
        FEET,
        EYES;

    }
}

