/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.MinecraftServer;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record PluginMessagePacket(String channel, byte[] data) implements ServerPacket
{
    public PluginMessagePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.RAW_BYTES));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.channel);
        writer.write(NetworkBuffer.RAW_BYTES, this.data);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.PLUGIN_MESSAGE;
    }

    @NotNull
    public static PluginMessagePacket getBrandPacket() {
        String brandName = MinecraftServer.getBrandName();
        byte[] data = NetworkBuffer.makeArray(networkBuffer -> networkBuffer.write(NetworkBuffer.STRING, brandName));
        return new PluginMessagePacket("minecraft:brand", data);
    }
}

