/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.network.packet.server.play.data.DeathLocation;
import org.jetbrains.annotations.NotNull;

public record RespawnPacket(String dimensionType, String worldName, long hashedSeed, GameMode gameMode, GameMode previousGameMode, boolean isDebug, boolean isFlat, boolean copyMeta, DeathLocation deathLocation, int portalCooldown) implements ServerPacket
{
    public RespawnPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), GameMode.fromId(reader.read(NetworkBuffer.BYTE).byteValue()), GameMode.fromId(reader.read(NetworkBuffer.BYTE).byteValue()), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.DEATH_LOCATION), reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.dimensionType);
        writer.write(NetworkBuffer.STRING, this.worldName);
        writer.write(NetworkBuffer.LONG, this.hashedSeed);
        writer.write(NetworkBuffer.BYTE, this.gameMode.id());
        writer.write(NetworkBuffer.BYTE, this.previousGameMode.id());
        writer.write(NetworkBuffer.BOOLEAN, this.isDebug);
        writer.write(NetworkBuffer.BOOLEAN, this.isFlat);
        writer.write(NetworkBuffer.BOOLEAN, this.copyMeta);
        writer.write(NetworkBuffer.DEATH_LOCATION, this.deathLocation);
        writer.write(NetworkBuffer.VAR_INT, this.portalCooldown);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.RESPAWN;
    }
}

