/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TabCompletePacket(int transactionId, int start, int length, @NotNull List<Match> matches) implements ComponentHoldingServerPacket
{
    public TabCompletePacket(int transactionId, int start, int length, @NotNull List<Match> matches) {
        matches = List.copyOf(matches);
    }

    public TabCompletePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.readCollection(Match::new));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.transactionId);
        writer.write(NetworkBuffer.VAR_INT, this.start);
        writer.write(NetworkBuffer.VAR_INT, this.length);
        writer.writeCollection(this.matches);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.TAB_COMPLETE;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        if (this.matches.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> components = new ArrayList<Component>(this.matches.size());
        for (Match match : this.matches) {
            if (match.tooltip == null) continue;
            components.add(match.tooltip);
        }
        return components;
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        if (this.matches.isEmpty()) {
            return this;
        }
        List<Match> updatedMatches = this.matches.stream().map(match -> match.copyWithOperator((UnaryOperator)operator)).toList();
        return new TabCompletePacket(this.transactionId, this.start, this.length, updatedMatches);
    }

    public record Match(@NotNull String match, @Nullable Component tooltip) implements NetworkBuffer.Writer,
    ComponentHolder<Match>
    {
        public Match(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.BOOLEAN) != false ? reader.read(NetworkBuffer.COMPONENT) : null);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.match);
            writer.writeOptional(NetworkBuffer.COMPONENT, this.tooltip);
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return this.tooltip != null ? List.of(this.tooltip) : List.of();
        }

        @Override
        @NotNull
        public Match copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return this.tooltip != null ? new Match(this.match, (Component)operator.apply(this.tooltip)) : this;
        }
    }
}

