/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minestom.server.MinecraftServer;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public record TagsPacket(@NotNull Map<Tag.BasicType, List<Tag>> tagsMap) implements ServerPacket
{
    @ApiStatus.Internal
    public static final CachedPacket DEFAULT_TAGS = new CachedPacket(new TagsPacket(MinecraftServer.getTagManager().getTagMap()));

    public TagsPacket(@NotNull Map<Tag.BasicType, List<Tag>> tagsMap) {
        tagsMap = Map.copyOf(tagsMap);
    }

    public TagsPacket(@NotNull NetworkBuffer reader) {
        this(TagsPacket.readTagsMap(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.tagsMap.size());
        for (Map.Entry<Tag.BasicType, List<Tag>> entry : this.tagsMap.entrySet()) {
            Tag.BasicType type = entry.getKey();
            List<Tag> tags = entry.getValue();
            writer.write(NetworkBuffer.STRING, type.getIdentifier());
            writer.write(NetworkBuffer.VAR_INT, tags.size());
            for (Tag tag : tags) {
                writer.write(NetworkBuffer.STRING, tag.getName().asString());
                Set<NamespaceID> values = tag.getValues();
                writer.write(NetworkBuffer.VAR_INT, values.size());
                for (NamespaceID name : values) {
                    writer.write(NetworkBuffer.VAR_INT, type.getFunction().apply(name.asString()));
                }
            }
        }
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.TAGS;
    }

    private static Map<Tag.BasicType, List<Tag>> readTagsMap(@NotNull NetworkBuffer reader) {
        EnumMap<Tag.BasicType, List<Tag>> tagsMap = new EnumMap<Tag.BasicType, List<Tag>>(Tag.BasicType.class);
        int typeCount = reader.read(NetworkBuffer.VAR_INT);
        for (int i = 0; i < typeCount; ++i) {
            Tag.BasicType tagType = Tag.BasicType.fromIdentifer(reader.read(NetworkBuffer.STRING));
            if (tagType == null) {
                throw new IllegalArgumentException("Tag type could not be resolved");
            }
            int tagCount = reader.read(NetworkBuffer.VAR_INT);
            for (int j = 0; j < tagCount; ++j) {
                String tagName = reader.read(NetworkBuffer.STRING);
                int[] nArray = reader.read(NetworkBuffer.VAR_INT_ARRAY);
            }
        }
        return tagsMap;
    }
}

