/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record WindowItemsPacket(byte windowId, int stateId, @NotNull List<ItemStack> items, @NotNull ItemStack carriedItem) implements ComponentHoldingServerPacket
{
    public WindowItemsPacket(byte windowId, int stateId, @NotNull List<ItemStack> items, @NotNull ItemStack carriedItem) {
        items = List.copyOf(items);
    }

    public WindowItemsPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.VAR_INT), reader.readCollection(NetworkBuffer.ITEM), reader.read(NetworkBuffer.ITEM));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE, this.windowId);
        writer.write(NetworkBuffer.VAR_INT, this.stateId);
        writer.writeCollection(NetworkBuffer.ITEM, this.items);
        writer.write(NetworkBuffer.ITEM, this.carriedItem);
    }

    @Override
    public int getId() {
        return ServerPacketIdentifier.WINDOW_ITEMS;
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.items);
        list.add(this.carriedItem);
        ArrayList<Component> components = new ArrayList<Component>();
        list.forEach(itemStack -> {
            components.addAll(itemStack.getLore());
            Component displayName = itemStack.getDisplayName();
            if (displayName == null) {
                return;
            }
            components.add(displayName);
        });
        return components;
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new WindowItemsPacket(this.windowId, this.stateId, this.items.stream().map(stack -> stack.withDisplayName(operator).withLore(lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        })).toList(), this.carriedItem.withDisplayName(operator).withLore(lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        }));
    }
}

