/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minestom.server.network.packet.server.play.DeclareRecipesPacket;
import net.minestom.server.recipe.BlastingRecipe;
import net.minestom.server.recipe.CampfireCookingRecipe;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.ShapedRecipe;
import net.minestom.server.recipe.ShapelessRecipe;
import net.minestom.server.recipe.SmeltingRecipe;
import net.minestom.server.recipe.SmithingRecipe;
import net.minestom.server.recipe.SmokingRecipe;
import net.minestom.server.recipe.StonecutterRecipe;
import org.jetbrains.annotations.NotNull;

public class RecipeManager {
    private DeclareRecipesPacket declareRecipesPacket = new DeclareRecipesPacket(List.of());
    private final Set<Recipe> recipes = new CopyOnWriteArraySet<Recipe>();

    public void addRecipes(Recipe ... recipe) {
        if (this.recipes.addAll(List.of(recipe))) {
            this.refreshRecipesPacket();
        }
    }

    public void addRecipe(@NotNull Recipe recipe) {
        if (this.recipes.add(recipe)) {
            this.refreshRecipesPacket();
        }
    }

    public void removeRecipe(@NotNull Recipe recipe) {
        if (this.recipes.remove(recipe)) {
            this.refreshRecipesPacket();
        }
    }

    @NotNull
    public Set<Recipe> getRecipes() {
        return this.recipes;
    }

    @NotNull
    public DeclareRecipesPacket getDeclareRecipesPacket() {
        return this.declareRecipesPacket;
    }

    private void refreshRecipesPacket() {
        ArrayList<DeclareRecipesPacket.DeclaredRecipe> recipesCache = new ArrayList<DeclareRecipesPacket.DeclaredRecipe>();
        for (Recipe recipe : this.recipes) {
            switch (recipe.recipeType) {
                case SHAPELESS: {
                    ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredShapelessCraftingRecipe(shapelessRecipe.getRecipeId(), shapelessRecipe.getGroup(), shapelessRecipe.getIngredients(), shapelessRecipe.getResult()));
                    break;
                }
                case SHAPED: {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredShapedCraftingRecipe(shapedRecipe.getRecipeId(), shapedRecipe.getWidth(), shapedRecipe.getHeight(), shapedRecipe.getGroup(), shapedRecipe.getIngredients(), shapedRecipe.getResult()));
                    break;
                }
                case SMELTING: {
                    SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredSmeltingRecipe(smeltingRecipe.getRecipeId(), smeltingRecipe.getGroup(), smeltingRecipe.getIngredient(), smeltingRecipe.getResult(), smeltingRecipe.getExperience(), smeltingRecipe.getCookingTime()));
                    break;
                }
                case BLASTING: {
                    BlastingRecipe blastingRecipe = (BlastingRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredBlastingRecipe(blastingRecipe.getRecipeId(), blastingRecipe.getGroup(), blastingRecipe.getIngredient(), blastingRecipe.getResult(), blastingRecipe.getExperience(), blastingRecipe.getCookingTime()));
                    break;
                }
                case SMOKING: {
                    SmokingRecipe smokingRecipe = (SmokingRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredSmokingRecipe(smokingRecipe.getRecipeId(), smokingRecipe.getGroup(), smokingRecipe.getIngredient(), smokingRecipe.getResult(), smokingRecipe.getExperience(), smokingRecipe.getCookingTime()));
                    break;
                }
                case CAMPFIRE_COOKING: {
                    CampfireCookingRecipe campfireCookingRecipe = (CampfireCookingRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredCampfireCookingRecipe(campfireCookingRecipe.getRecipeId(), campfireCookingRecipe.getGroup(), campfireCookingRecipe.getIngredient(), campfireCookingRecipe.getResult(), campfireCookingRecipe.getExperience(), campfireCookingRecipe.getCookingTime()));
                    break;
                }
                case STONECUTTING: {
                    StonecutterRecipe stonecuttingRecipe = (StonecutterRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredStonecutterRecipe(stonecuttingRecipe.getRecipeId(), stonecuttingRecipe.getGroup(), stonecuttingRecipe.getIngredient(), stonecuttingRecipe.getResult()));
                    break;
                }
                case SMITHING: {
                    SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
                    recipesCache.add(new DeclareRecipesPacket.DeclaredSmithingRecipe(smithingRecipe.getRecipeId(), smithingRecipe.getBaseIngredient(), smithingRecipe.getAdditionIngredient(), smithingRecipe.getResult()));
                }
            }
        }
        this.declareRecipesPacket = new DeclareRecipesPacket(recipesCache);
    }
}

