/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.util.function.Supplier;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.Scheduler;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskSchedule;
import org.jctools.queues.MpmcUnboundedXaddArrayQueue;
import org.jetbrains.annotations.NotNull;

public final class SchedulerManager
implements Scheduler {
    private final Scheduler scheduler = Scheduler.newScheduler();
    private final MpmcUnboundedXaddArrayQueue<Runnable> shutdownTasks = new MpmcUnboundedXaddArrayQueue(1024);

    @Override
    public void process() {
        this.scheduler.process();
    }

    @Override
    public void processTick() {
        this.scheduler.processTick();
    }

    @Override
    @NotNull
    public Task submitTask(@NotNull Supplier<TaskSchedule> task, @NotNull ExecutionType executionType) {
        return this.scheduler.submitTask(task, executionType);
    }

    public void shutdown() {
        this.shutdownTasks.drain(Runnable::run);
    }

    public void buildShutdownTask(@NotNull Runnable runnable) {
        this.shutdownTasks.relaxedOffer((Object)runnable);
    }
}

