/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import org.jetbrains.annotations.NotNull;

public enum Direction {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0);

    public static final Direction[] HORIZONTAL;
    private final int normalX;
    private final int normalY;
    private final int normalZ;

    private Direction(int normalX, int normalY, int normalZ) {
        this.normalX = normalX;
        this.normalY = normalY;
        this.normalZ = normalZ;
    }

    public int normalX() {
        return this.normalX;
    }

    public int normalY() {
        return this.normalY;
    }

    public int normalZ() {
        return this.normalZ;
    }

    @NotNull
    public Direction opposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> DOWN;
            case DOWN -> UP;
            case EAST -> WEST;
            case WEST -> EAST;
            case NORTH -> SOUTH;
            case SOUTH -> NORTH;
        };
    }

    static {
        HORIZONTAL = new Direction[]{SOUTH, WEST, NORTH, EAST};
    }
}

