/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.lang.ref.Cleaner;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minestom.server.network.socket.Server;
import net.minestom.server.utils.binary.BinaryBuffer;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpmcUnboundedXaddArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class ObjectPool<T> {
    private static final int QUEUE_SIZE = 32768;
    private static final int BUFFER_SIZE = Integer.getInteger("minestom.pooled-buffer-size", 262143);
    public static final ObjectPool<BinaryBuffer> BUFFER_POOL = new ObjectPool<BinaryBuffer>(() -> BinaryBuffer.ofSize(BUFFER_SIZE), BinaryBuffer::clear);
    public static final ObjectPool<ByteBuffer> PACKET_POOL = new ObjectPool<ByteBuffer>(() -> ByteBuffer.allocateDirect(Server.MAX_PACKET_SIZE), ByteBuffer::clear);
    private final Cleaner cleaner = Cleaner.create();
    private final MessagePassingQueue<SoftReference<T>> pool = new MpmcUnboundedXaddArrayQueue(32768);
    private final Supplier<T> supplier;
    private final UnaryOperator<T> sanitizer;

    ObjectPool(Supplier<T> supplier, UnaryOperator<T> sanitizer) {
        this.supplier = supplier;
        this.sanitizer = sanitizer;
    }

    @NotNull
    public T get() {
        SoftReference ref;
        while ((ref = (SoftReference)this.pool.poll()) != null) {
            Object result = ref.get();
            if (result == null) continue;
            return result;
        }
        return this.supplier.get();
    }

    @NotNull
    public T getAndRegister(@NotNull Object ref) {
        T result = this.get();
        this.register(ref, result);
        return result;
    }

    public void add(@NotNull T object) {
        object = this.sanitizer.apply(object);
        this.pool.offer(new SoftReference<T>(object));
    }

    public void clear() {
        this.pool.clear();
    }

    public int count() {
        return this.pool.size();
    }

    public void register(@NotNull Object ref, @NotNull AtomicReference<T> objectRef) {
        this.cleaner.register(ref, new BufferRefCleaner<T>(this, objectRef));
    }

    public void register(@NotNull Object ref, @NotNull T object) {
        this.cleaner.register(ref, new BufferCleaner<T>(this, object));
    }

    public void register(@NotNull Object ref, @NotNull Collection<T> objects) {
        this.cleaner.register(ref, new BuffersCleaner<T>(this, objects));
    }

    @NotNull
    public Holder hold() {
        return new Holder(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R use(@NotNull @NotNull Function<@NotNull T, R> function) {
        T object = this.get();
        try {
            R r = function.apply(object);
            return r;
        }
        finally {
            this.add(object);
        }
    }

    private record BufferRefCleaner<T>(ObjectPool<T> pool, AtomicReference<T> objectRef) implements Runnable
    {
        @Override
        public void run() {
            this.pool.add(this.objectRef.get());
        }
    }

    private record BufferCleaner<T>(ObjectPool<T> pool, T object) implements Runnable
    {
        @Override
        public void run() {
            this.pool.add(this.object);
        }
    }

    private record BuffersCleaner<T>(ObjectPool<T> pool, Collection<T> objects) implements Runnable
    {
        @Override
        public void run() {
            for (T buffer : this.objects) {
                this.pool.add(buffer);
            }
        }
    }

    public final class Holder
    implements AutoCloseable {
        private final T object;
        private boolean closed;

        Holder(T object) {
            this.object = object;
        }

        @NotNull
        public T get() {
            if (this.closed) {
                throw new IllegalStateException("Holder is closed");
            }
            return this.object;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                ObjectPool.this.add(this.object);
            }
        }
    }
}

