/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.minestom.server.MinecraftServer;
import net.minestom.server.Viewable;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.utils.ObjectPool;
import net.minestom.server.utils.PropertyUtils;
import net.minestom.server.utils.Utils;
import net.minestom.server.utils.binary.BinaryBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PacketUtils {
    private static final ThreadLocal<Deflater> LOCAL_DEFLATER = ThreadLocal.withInitial(Deflater::new);
    public static final boolean GROUPED_PACKET = PropertyUtils.getBoolean("minestom.grouped-packet", true);
    public static final boolean CACHED_PACKET = PropertyUtils.getBoolean("minestom.cached-packet", true);
    public static final boolean VIEWABLE_PACKET = PropertyUtils.getBoolean("minestom.viewable-packet", true);
    private static final Cache<Viewable, ViewableStorage> VIEWABLE_STORAGE_MAP = Caffeine.newBuilder().weakKeys().build();

    private PacketUtils() {
    }

    public static void sendPacket(@NotNull Audience audience, @NotNull ServerPacket packet) {
        if (audience instanceof Player) {
            Player player = (Player)audience;
            player.sendPacket(packet);
        } else if (audience instanceof PacketGroupingAudience) {
            PacketGroupingAudience groupingAudience = (PacketGroupingAudience)audience;
            PacketUtils.sendGroupedPacket(groupingAudience.getPlayers(), packet);
        } else if (audience instanceof ForwardingAudience.Single) {
            ForwardingAudience.Single singleAudience = (ForwardingAudience.Single)audience;
            PacketUtils.sendPacket(singleAudience.audience(), packet);
        } else if (audience instanceof ForwardingAudience) {
            ForwardingAudience forwardingAudience = (ForwardingAudience)audience;
            for (Audience member : forwardingAudience.audiences()) {
                PacketUtils.sendPacket(member, packet);
            }
        }
    }

    public static void sendGroupedPacket(@NotNull Collection<Player> players, @NotNull ServerPacket packet, @NotNull Predicate<Player> predicate) {
        SendablePacket sendablePacket = PacketUtils.shouldUseCachePacket(packet) ? new CachedPacket(packet) : packet;
        players.forEach(player -> {
            if (predicate.test((Player)player)) {
                player.sendPacket(sendablePacket);
            }
        });
    }

    static boolean shouldUseCachePacket(@NotNull ServerPacket packet) {
        if (!MinestomAdventure.AUTOMATIC_COMPONENT_TRANSLATION) {
            return GROUPED_PACKET;
        }
        if (!(packet instanceof ComponentHoldingServerPacket)) {
            return GROUPED_PACKET;
        }
        ComponentHoldingServerPacket holder = (ComponentHoldingServerPacket)packet;
        return !PacketUtils.containsTranslatableComponents(holder);
    }

    private static boolean containsTranslatableComponents(@NotNull ComponentHolder<?> holder) {
        for (Component component : holder.components()) {
            if (!PacketUtils.isTranslatable(component)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTranslatable(@NotNull Component component) {
        if (component instanceof TranslatableComponent) {
            return true;
        }
        List children = component.children();
        if (children.isEmpty()) {
            return false;
        }
        for (Component child : children) {
            if (!PacketUtils.isTranslatable(child)) continue;
            return true;
        }
        return false;
    }

    public static void sendGroupedPacket(@NotNull Collection<Player> players, @NotNull ServerPacket packet) {
        PacketUtils.sendGroupedPacket(players, packet, player -> true);
    }

    public static void broadcastPacket(@NotNull ServerPacket packet) {
        PacketUtils.sendGroupedPacket(MinecraftServer.getConnectionManager().getOnlinePlayers(), packet);
    }

    @ApiStatus.Experimental
    public static void prepareViewablePacket(@NotNull Viewable viewable, @NotNull ServerPacket serverPacket, @Nullable Entity entity) {
        if (entity != null && !entity.hasPredictableViewers()) {
            entity.sendPacketToViewers(serverPacket);
            return;
        }
        if (!VIEWABLE_PACKET) {
            PacketUtils.sendGroupedPacket(viewable.getViewers(), serverPacket, value -> !Objects.equals(value, entity));
            return;
        }
        Player exception = entity instanceof Player ? (Player)entity : null;
        ViewableStorage storage = (ViewableStorage)VIEWABLE_STORAGE_MAP.get((Object)viewable, unused -> new ViewableStorage());
        storage.append(viewable, serverPacket, exception);
    }

    @ApiStatus.Experimental
    public static void prepareViewablePacket(@NotNull Viewable viewable, @NotNull ServerPacket serverPacket) {
        PacketUtils.prepareViewablePacket(viewable, serverPacket, null);
    }

    @ApiStatus.Internal
    public static void flush() {
        if (VIEWABLE_PACKET) {
            VIEWABLE_STORAGE_MAP.asMap().entrySet().parallelStream().forEach(entry -> ((ViewableStorage)entry.getValue()).process((Viewable)entry.getKey()));
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static BinaryBuffer readPackets(@NotNull BinaryBuffer readBuffer, boolean compressed, BiConsumer<Integer, ByteBuffer> payloadConsumer) throws DataFormatException {
        BinaryBuffer remaining = null;
        ByteBuffer pool = ObjectPool.PACKET_POOL.get();
        while (readBuffer.readableBytes() > 0) {
            BinaryBuffer.Marker beginMark = readBuffer.mark();
            try {
                int packetLength = readBuffer.readVarInt();
                int readerStart = readBuffer.readerOffset();
                if (!readBuffer.canRead(packetLength)) {
                    throw new BufferUnderflowException();
                }
                BinaryBuffer content = readBuffer;
                int decompressedSize = packetLength;
                if (compressed) {
                    int dataLength = readBuffer.readVarInt();
                    int payloadLength = packetLength - (readBuffer.readerOffset() - readerStart);
                    if (payloadLength < 0) {
                        throw new DataFormatException("Negative payload length " + payloadLength);
                    }
                    if (dataLength == 0) {
                        decompressedSize = payloadLength;
                    } else {
                        content = BinaryBuffer.wrap(pool);
                        decompressedSize = dataLength;
                        Inflater inflater = new Inflater();
                        inflater.setInput(readBuffer.asByteBuffer(readBuffer.readerOffset(), payloadLength));
                        inflater.inflate(content.asByteBuffer(0, dataLength));
                        inflater.reset();
                    }
                }
                ByteBuffer payload = content.asByteBuffer(content.readerOffset(), decompressedSize);
                int packetId = Utils.readVarInt(payload);
                try {
                    payloadConsumer.accept(packetId, payload);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                readBuffer.readerOffset(readerStart + packetLength);
            }
            catch (BufferUnderflowException e) {
                readBuffer.reset(beginMark);
                remaining = BinaryBuffer.copy(readBuffer);
                break;
            }
        }
        ObjectPool.PACKET_POOL.add(pool);
        return remaining;
    }

    public static void writeFramedPacket(@NotNull ByteBuffer buffer, @NotNull ServerPacket packet, boolean compression) {
        PacketUtils.writeFramedPacket(buffer, packet.getId(), packet, compression ? MinecraftServer.getCompressionThreshold() : 0);
    }

    public static void writeFramedPacket(@NotNull ByteBuffer buffer, int id, @NotNull NetworkBuffer.Writer writer, int compressionThreshold) {
        boolean compressed;
        NetworkBuffer networkBuffer = new NetworkBuffer(buffer, false);
        if (compressionThreshold <= 0) {
            int lengthIndex = networkBuffer.skipWrite(3);
            networkBuffer.write(NetworkBuffer.VAR_INT, id);
            networkBuffer.write(writer);
            int finalSize = networkBuffer.writeIndex() - (lengthIndex + 3);
            Utils.writeVarIntHeader(buffer, lengthIndex, finalSize);
            buffer.position(networkBuffer.writeIndex());
            return;
        }
        int compressedIndex = networkBuffer.skipWrite(3);
        int uncompressedIndex = networkBuffer.skipWrite(3);
        int contentStart = networkBuffer.writeIndex();
        networkBuffer.write(NetworkBuffer.VAR_INT, id);
        networkBuffer.write(writer);
        int packetSize = networkBuffer.writeIndex() - contentStart;
        boolean bl = compressed = packetSize >= compressionThreshold;
        if (compressed) {
            try (ObjectPool.Holder hold = ObjectPool.PACKET_POOL.hold();){
                ByteBuffer input = ((ByteBuffer)hold.get()).put(0, buffer, contentStart, packetSize);
                Deflater deflater = LOCAL_DEFLATER.get();
                deflater.setInput(input.limit(packetSize));
                deflater.finish();
                deflater.deflate(buffer.position(contentStart));
                deflater.reset();
                networkBuffer.skipWrite(buffer.position() - contentStart);
            }
        }
        Utils.writeVarIntHeader(buffer, compressedIndex, networkBuffer.writeIndex() - uncompressedIndex);
        Utils.writeVarIntHeader(buffer, uncompressedIndex, compressed ? packetSize : 0);
        buffer.position(networkBuffer.writeIndex());
    }

    @ApiStatus.Internal
    public static ByteBuffer createFramedPacket(@NotNull ByteBuffer buffer, @NotNull ServerPacket packet, boolean compression) {
        PacketUtils.writeFramedPacket(buffer, packet, compression);
        return buffer.flip();
    }

    @ApiStatus.Internal
    public static ByteBuffer createFramedPacket(@NotNull ByteBuffer buffer, @NotNull ServerPacket packet) {
        return PacketUtils.createFramedPacket(buffer, packet, MinecraftServer.getCompressionThreshold() > 0);
    }

    @ApiStatus.Internal
    public static FramedPacket allocateTrimmedPacket(@NotNull ServerPacket packet) {
        try (ObjectPool.Holder hold = ObjectPool.PACKET_POOL.hold();){
            ByteBuffer temp = PacketUtils.createFramedPacket((ByteBuffer)hold.get(), packet);
            int size = temp.remaining();
            ByteBuffer buffer = ByteBuffer.allocateDirect(size).put(0, temp, 0, size);
            FramedPacket framedPacket = new FramedPacket(packet, buffer);
            return framedPacket;
        }
    }

    private static final class ViewableStorage {
        private final Int2ObjectMap<LongArrayList> entityIdMap = new Int2ObjectOpenHashMap();
        private final BinaryBuffer buffer = ObjectPool.BUFFER_POOL.getAndRegister(this);

        private ViewableStorage() {
        }

        private synchronized void append(Viewable viewable, ServerPacket serverPacket, Player player) {
            try (ObjectPool.Holder hold = ObjectPool.PACKET_POOL.hold();){
                ByteBuffer framedPacket = PacketUtils.createFramedPacket((ByteBuffer)hold.get(), serverPacket);
                int packetSize = framedPacket.limit();
                if (packetSize >= this.buffer.capacity()) {
                    this.process(viewable);
                    for (Player viewer : viewable.getViewers()) {
                        if (Objects.equals(player, viewer)) continue;
                        ViewableStorage.writeTo(viewer.getPlayerConnection(), framedPacket, 0, packetSize);
                    }
                    return;
                }
                if (!this.buffer.canWrite(packetSize)) {
                    this.process(viewable);
                }
                int start = this.buffer.writerOffset();
                this.buffer.write(framedPacket);
                int end = this.buffer.writerOffset();
                if (player != null) {
                    long offsets = (long)start << 32 | (long)end & 0xFFFFFFFFL;
                    LongList list = (LongList)this.entityIdMap.computeIfAbsent(player.getEntityId(), id -> new LongArrayList());
                    list.add(offsets);
                }
            }
        }

        private synchronized void process(Viewable viewable) {
            if (this.buffer.writerOffset() == 0) {
                return;
            }
            ByteBuffer copy = ByteBuffer.allocateDirect(this.buffer.writerOffset());
            copy.put(this.buffer.asByteBuffer(0, copy.capacity()));
            viewable.getViewers().forEach(player -> this.processPlayer((Player)player, copy));
            this.buffer.clear();
            this.entityIdMap.clear();
        }

        private void processPlayer(Player player, ByteBuffer buffer) {
            int size = buffer.limit();
            PlayerConnection connection = player.getPlayerConnection();
            LongArrayList pairs = (LongArrayList)this.entityIdMap.get(player.getEntityId());
            if (pairs != null) {
                int lastWrite = 0;
                long[] elements = pairs.elements();
                for (int i = 0; i < pairs.size(); ++i) {
                    long offsets = elements[i];
                    int start = (int)(offsets >> 32);
                    if (start != lastWrite) {
                        ViewableStorage.writeTo(connection, buffer, lastWrite, start - lastWrite);
                    }
                    lastWrite = (int)offsets;
                }
                if (size != lastWrite) {
                    ViewableStorage.writeTo(connection, buffer, lastWrite, size - lastWrite);
                }
            } else {
                ViewableStorage.writeTo(connection, buffer, 0, size);
            }
        }

        private static void writeTo(PlayerConnection connection, ByteBuffer buffer, int offset, int length) {
            if (connection instanceof PlayerSocketConnection) {
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
                socketConnection.write(buffer, offset, length);
                return;
            }
        }
    }
}

