/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String value = System.getProperty(name);
            if (value != null) {
                result = Boolean.parseBoolean(value);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static String getString(@NotNull String name, @Nullable String defaultValue) {
        return System.getProperty(name, defaultValue);
    }
}

