/*
 * Decompiled with CFR 0.152.
 */
package dev.hydraulic.conveyor.control;

import java.io.IOException;
import java.util.ServiceLoader;

public interface SoftwareUpdateController {
    public static SoftwareUpdateController getInstance() {
        return ServiceLoader.load(SoftwareUpdateController.class).findFirst().orElse(null);
    }

    public void triggerUpdateCheckUI();

    public Version getCurrentVersion();

    public Version getCurrentVersionFromRepository() throws UpdateCheckException;

    public Availability canTriggerUpdateCheckUI();

    public static enum Availability {
        AVAILABLE,
        UNIMPLEMENTED,
        UNSUPPORTED_PACKAGE_TYPE,
        NON_GUI_APP,
        OTHER;

    }

    public static class UpdateCheckException
    extends IOException {
        public UpdateCheckException() {
        }

        public UpdateCheckException(String message) {
            super(message);
        }

        public UpdateCheckException(String message, Throwable cause) {
            super(message, cause);
        }

        public UpdateCheckException(Throwable cause) {
            super(cause);
        }
    }

    public static interface Version
    extends Comparable<Version> {
        public String getVersion();

        public int getRevision();

        @Override
        public int compareTo(Version var1);
    }
}

