/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack;

import iabudiab.maven.plugins.dependencytrack.client.DTrackClient;
import java.net.URISyntaxException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDependencyTrackMojo
extends AbstractMojo {
    @Parameter(property="dependencyTrackUrl", required=true)
    private String dependencyTrackUrl;
    @Parameter(property="dependencyTrackApiKey", required=true)
    private String dependencyTrackApiKey;
    @Parameter(property="projectName", defaultValue="${project.groupId}.${project.artifactId}", required=true)
    protected String projectName;
    @Parameter(property="projectVersion", defaultValue="${project.version}", required=true)
    protected String projectVersion;
    @Parameter(property="failOnError", defaultValue="true", required=true)
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logConfiguration();
        try {
            DTrackClient client = new DTrackClient(this.dependencyTrackUrl, this.dependencyTrackApiKey, this.getLog());
            this.doWork(client);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Error during plugin execution", (Exception)e);
        }
        catch (MojoFailureException e) {
            this.handleFailureException(e);
        }
    }

    private void handleFailureException(MojoFailureException e) throws MojoFailureException {
        if (this.failOnError) {
            throw e;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Throwable)e);
        } else {
            this.getLog().warn((CharSequence)e.getMessage());
        }
    }

    protected abstract void doWork(DTrackClient var1) throws MojoExecutionException, MojoFailureException;

    private void logConfiguration() {
        this.getLog().info((CharSequence)"DependencyTrack Maven Plugin");
        this.getLog().info((CharSequence)("DependencyTrack URL   : " + this.dependencyTrackUrl));
        this.getLog().info((CharSequence)("Project name          : " + this.projectName));
        this.getLog().info((CharSequence)("Project version       : " + this.projectVersion));
    }
}

