/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack;

import iabudiab.maven.plugins.dependencytrack.AbstractDependencyTrackMojo;
import iabudiab.maven.plugins.dependencytrack.SecurityGate;
import iabudiab.maven.plugins.dependencytrack.SecurityGateRejectionException;
import iabudiab.maven.plugins.dependencytrack.client.DTrackClient;
import iabudiab.maven.plugins.dependencytrack.client.model.Finding;
import iabudiab.maven.plugins.dependencytrack.client.model.FindingsReport;
import iabudiab.maven.plugins.dependencytrack.client.model.Project;
import iabudiab.maven.plugins.dependencytrack.client.model.ProjectMetrics;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check-token", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true)
public class CheckPendingTokenMojo
extends AbstractDependencyTrackMojo {
    @Parameter(defaultValue="${project.build.directory}/dependency-track/pendingToken", property="tokenFile")
    private String tokenFile;
    @Parameter(property="tokenValue")
    private String tokenValue;
    @Parameter(defaultValue="60", property="tokenPollingDuration", required=true)
    private Integer tokenPollingDuration;
    @Parameter(property="securityGate", required=false)
    private SecurityGate securityGate = SecurityGate.strict();

    @Override
    protected void doWork(DTrackClient client) throws MojoExecutionException, SecurityGateRejectionException {
        ProjectMetrics projectMetrics;
        Project project;
        try {
            project = client.getProject(this.projectName, this.projectVersion);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error loading project: ", (Exception)e);
        }
        try {
            UUID token = this.loadToken();
            boolean isProcessingToken = client.pollTokenProcessing(token, ForkJoinPool.commonPool()).get(this.tokenPollingDuration.intValue(), TimeUnit.SECONDS);
            if (isProcessingToken) {
                this.getLog().info((CharSequence)"Timeout while waiting for BOM token, bailing out.");
                return;
            }
            List<Finding> findings = client.getProjectFindings(project.getUuid());
            FindingsReport findingsReport = new FindingsReport(findings);
            this.getLog().info(findingsReport.printSummary());
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Error processing project findings: ", e);
        }
        try {
            projectMetrics = client.getProjectMetrics(project.getUuid());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error fetching project metrics: ", (Exception)e);
        }
        this.getLog().info(projectMetrics.printMetrics());
        this.getLog().info(this.securityGate.printThresholds());
        this.securityGate.applyOn(projectMetrics);
    }

    private UUID loadToken() throws IOException {
        UUID token = null;
        Path tokenPath = Paths.get(this.tokenFile, new String[0]);
        if (Files.exists(tokenPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Loading token from: " + tokenPath.toString()));
            byte[] bytes = Files.readAllBytes(tokenPath);
            String tokenString = new String(bytes, StandardCharsets.UTF_8);
            token = UUID.fromString(tokenString);
        }
        if (this.tokenValue != null && this.tokenValue != "") {
            this.getLog().info((CharSequence)("Using provided tokenValue: " + this.tokenValue));
            token = UUID.fromString(this.tokenValue);
        }
        return token;
    }
}

