/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack;

import iabudiab.maven.plugins.dependencytrack.AbstractDependencyTrackMojo;
import iabudiab.maven.plugins.dependencytrack.SecurityGate;
import iabudiab.maven.plugins.dependencytrack.SecurityGateRejectionException;
import iabudiab.maven.plugins.dependencytrack.client.DTrackClient;
import iabudiab.maven.plugins.dependencytrack.client.model.Finding;
import iabudiab.maven.plugins.dependencytrack.client.model.FindingsReport;
import iabudiab.maven.plugins.dependencytrack.client.model.Project;
import iabudiab.maven.plugins.dependencytrack.client.model.ProjectMetrics;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check-metrics", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true)
public class CheckProjectMetricsMojo
extends AbstractDependencyTrackMojo {
    @Parameter(property="securityGate", required=false)
    private SecurityGate securityGate = SecurityGate.strict();

    @Override
    protected void doWork(DTrackClient client) throws MojoExecutionException, SecurityGateRejectionException {
        ProjectMetrics projectMetrics;
        Project project;
        try {
            project = client.getProject(this.projectName, this.projectVersion);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error loading project: ", (Exception)e);
        }
        try {
            List<Finding> findings = client.getProjectFindings(project.getUuid());
            FindingsReport findingsReport = new FindingsReport(findings);
            this.getLog().info(findingsReport.printSummary());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing project findings: ", (Exception)e);
        }
        try {
            projectMetrics = client.getProjectMetrics(project.getUuid());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error fetching project metrics: ", (Exception)e);
        }
        this.getLog().info(projectMetrics.printMetrics());
        this.getLog().info(this.securityGate.printThresholds());
        this.securityGate.applyOn(projectMetrics);
    }
}

