/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack;

import iabudiab.maven.plugins.dependencytrack.AbstractDependencyTrackMojo;
import iabudiab.maven.plugins.dependencytrack.client.DTrackClient;
import iabudiab.maven.plugins.dependencytrack.client.model.Project;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.http.client.HttpResponseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="download-bom", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true)
public class DownloadBomMojo
extends AbstractDependencyTrackMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}_bom.xml", property="destinationPath", required=false)
    private String destinationPath;
    @Parameter(defaultValue="false", property="failedOnNotFound", required=false)
    private boolean failedOnNotFound;

    @Override
    protected void doWork(DTrackClient client) throws MojoExecutionException {
        Path path = Paths.get(this.destinationPath, new String[0]);
        try {
            Project project = client.getProject(this.projectName, this.projectVersion);
            client.downloadBom(project.getUuid(), path);
        }
        catch (HttpResponseException e) {
            this.handleProjectNotFound(e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error downloading bom: ", (Exception)e);
        }
    }

    private void handleProjectNotFound(HttpResponseException e) throws MojoExecutionException {
        if (e.getStatusCode() == 404) {
            if (this.failedOnNotFound) {
                throw new MojoExecutionException("Project not found: ", (Exception)((Object)e));
            }
        } else {
            throw new MojoExecutionException("Error downloading bom: ", (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)("failedOnNotFound=false, ignoring project not found: " + this.projectName + "-" + this.projectVersion));
    }
}

