/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack;

import iabudiab.maven.plugins.dependencytrack.SecurityGateRejectionException;
import iabudiab.maven.plugins.dependencytrack.client.model.ProjectMetrics;

public class SecurityGate {
    private int critical;
    private int high;
    private int medium;
    private int low;

    public static SecurityGate strict() {
        return new SecurityGate();
    }

    public void applyOn(ProjectMetrics projectMetrics) throws SecurityGateRejectionException {
        if (projectMetrics.getCritical() > this.critical || projectMetrics.getHigh() > this.high || projectMetrics.getMedium() > this.medium || projectMetrics.getLow() > this.low) {
            throw new SecurityGateRejectionException("Project did not pass the Security Gate");
        }
    }

    public CharSequence printThresholds() {
        StringBuilder builder = new StringBuilder();
        builder.append("--- Security Gate ---");
        builder.append("\n");
        builder.append("critical: ");
        builder.append(this.critical);
        builder.append(", high: ");
        builder.append(this.high);
        builder.append(", medium: ");
        builder.append(this.medium);
        builder.append(", low: ");
        builder.append(this.low);
        return builder.toString();
    }

    public int getCritical() {
        return this.critical;
    }

    public int getHigh() {
        return this.high;
    }

    public int getMedium() {
        return this.medium;
    }

    public int getLow() {
        return this.low;
    }

    public void setCritical(int critical) {
        this.critical = critical;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public void setMedium(int medium) {
        this.medium = medium;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityGate)) {
            return false;
        }
        SecurityGate other = (SecurityGate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCritical() != other.getCritical()) {
            return false;
        }
        if (this.getHigh() != other.getHigh()) {
            return false;
        }
        if (this.getMedium() != other.getMedium()) {
            return false;
        }
        return this.getLow() == other.getLow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityGate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCritical();
        result = result * 59 + this.getHigh();
        result = result * 59 + this.getMedium();
        result = result * 59 + this.getLow();
        return result;
    }

    public String toString() {
        return "SecurityGate(critical=" + this.getCritical() + ", high=" + this.getHigh() + ", medium=" + this.getMedium() + ", low=" + this.getLow() + ")";
    }
}

