/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack;

import iabudiab.maven.plugins.dependencytrack.AbstractDependencyTrackMojo;
import iabudiab.maven.plugins.dependencytrack.SecurityGate;
import iabudiab.maven.plugins.dependencytrack.SecurityGateRejectionException;
import iabudiab.maven.plugins.dependencytrack.Utils;
import iabudiab.maven.plugins.dependencytrack.client.DTrackClient;
import iabudiab.maven.plugins.dependencytrack.client.model.BomSubmitRequest;
import iabudiab.maven.plugins.dependencytrack.client.model.Finding;
import iabudiab.maven.plugins.dependencytrack.client.model.FindingsReport;
import iabudiab.maven.plugins.dependencytrack.client.model.Project;
import iabudiab.maven.plugins.dependencytrack.client.model.ProjectMetrics;
import iabudiab.maven.plugins.dependencytrack.client.model.TokenResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upload-bom", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true)
public class UploadBomMojo
extends AbstractDependencyTrackMojo {
    @Parameter(defaultValue="${project.build.directory}", property="artifactDir", required=true)
    private File artifactDirectory;
    @Parameter(defaultValue="bom.xml", property="artifactName", required=true)
    private String artifactName;
    @Parameter(defaultValue="true", property="pollToken", required=true)
    private boolean pollToken;
    @Parameter(defaultValue="${project.build.directory}/dependency-track/pendingToken", property="tokenFile", required=true)
    private String tokenFile;
    @Parameter(defaultValue="60", property="tokenPollingDuration", required=true)
    private Integer tokenPollingDuration;
    @Parameter(property="securityGate", required=false)
    private SecurityGate securityGate = SecurityGate.strict();

    @Override
    protected void doWork(DTrackClient client) throws MojoExecutionException, SecurityGateRejectionException {
        ProjectMetrics projectMetrics;
        Project project;
        TokenResponse tokenResponse;
        Path path = Paths.get(this.artifactDirectory.getPath(), this.artifactName);
        String encodeArtifact = Utils.loadAndEncodeArtifactFile(path);
        BomSubmitRequest payload = BomSubmitRequest.builder().projectName(this.projectName).projectVersion(this.projectVersion).bom(encodeArtifact).autoCreate(true).build();
        try {
            tokenResponse = client.uploadBom(payload);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error uploading bom: ", (Exception)e);
        }
        try {
            Path tokenFilePath = Paths.get(this.tokenFile, new String[0]);
            Files.createDirectories(tokenFilePath.getParent(), new FileAttribute[0]);
            byte[] tokenBytes = tokenResponse.getToken().toString().getBytes(StandardCharsets.UTF_8);
            Files.write(tokenFilePath, tokenBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            this.getLog().info((CharSequence)("Token has been written to: " + tokenFilePath.toString()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing token: ", (Exception)e);
        }
        if (!this.pollToken) {
            this.getLog().info((CharSequence)"Token polling is disabled. Nothing more to do.");
            return;
        }
        try {
            project = client.getProject(this.projectName, this.projectVersion);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error loading project: ", (Exception)e);
        }
        try {
            boolean isProcessingToken = client.pollTokenProcessing(tokenResponse.getToken(), ForkJoinPool.commonPool()).get(this.tokenPollingDuration.intValue(), TimeUnit.SECONDS);
            if (isProcessingToken) {
                this.getLog().info((CharSequence)"Timeout while waiting for BOM token, bailing out.");
                return;
            }
            List<Finding> findings = client.getProjectFindings(project.getUuid());
            FindingsReport findingsReport = new FindingsReport(findings);
            this.getLog().info(findingsReport.printSummary());
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Error processing project findings: ", e);
        }
        try {
            projectMetrics = client.getProjectMetrics(project.getUuid());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error fetching project metrics: ", (Exception)e);
        }
        this.getLog().info(projectMetrics.printMetrics());
        this.getLog().info(this.securityGate.printThresholds());
        this.securityGate.applyOn(projectMetrics);
    }
}

