/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack;

import iabudiab.maven.plugins.dependencytrack.AbstractDependencyTrackMojo;
import iabudiab.maven.plugins.dependencytrack.Utils;
import iabudiab.maven.plugins.dependencytrack.client.DTrackClient;
import iabudiab.maven.plugins.dependencytrack.client.model.ScanSubmitRequest;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upload-scan", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true)
public class UploadScanMojo
extends AbstractDependencyTrackMojo {
    @Parameter(defaultValue="${project.build.directory}", property="artifactDir", required=true)
    private File artifactDirectory;
    @Parameter(defaultValue="dependency-check-report.xml", property="artifactName", required=true)
    private String artifactName;

    @Override
    protected void doWork(DTrackClient client) throws MojoExecutionException {
        Path path = Paths.get(this.artifactDirectory.getPath(), this.artifactName);
        String encodeArtifact = Utils.loadAndEncodeArtifactFile(path);
        ScanSubmitRequest payload = ScanSubmitRequest.builder().projectName(this.projectName).projectVersion(this.projectVersion).scan(encodeArtifact).autoCreate(true).build();
        try {
            client.uploadScan(payload);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error uploading scan: ", (Exception)e);
        }
    }
}

