/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack.client;

import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class CompletableFutureBackports {
    private static final Executor POOL = ForkJoinPool.commonPool().getParallelism() > 1 ? ForkJoinPool.commonPool() : runnable -> new Thread(runnable).start();

    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        return new DelayedExecutor(delay, unit, POOL);
    }

    private CompletableFutureBackports() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class DelayedExecutor
    implements Executor {
        private static final ScheduledThreadPoolExecutor DELAYED = new ScheduledThreadPoolExecutor(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
        private final long delay;
        private final TimeUnit unit;
        private final Executor executor;

        @Override
        public void execute(Runnable r) {
            DELAYED.schedule(() -> this.executor.execute(r), this.delay, this.unit);
        }

        public DelayedExecutor(long delay, TimeUnit unit, Executor executor) {
            this.delay = delay;
            this.unit = unit;
            this.executor = executor;
        }

        static {
            DELAYED.setRemoveOnCancelPolicy(true);
        }
    }
}

