/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import iabudiab.maven.plugins.dependencytrack.client.CompletableFutureBackports;
import iabudiab.maven.plugins.dependencytrack.client.model.BomSubmitRequest;
import iabudiab.maven.plugins.dependencytrack.client.model.Finding;
import iabudiab.maven.plugins.dependencytrack.client.model.Project;
import iabudiab.maven.plugins.dependencytrack.client.model.ProjectMetrics;
import iabudiab.maven.plugins.dependencytrack.client.model.ScanSubmitRequest;
import iabudiab.maven.plugins.dependencytrack.client.model.TokenProcessedResponse;
import iabudiab.maven.plugins.dependencytrack.client.model.TokenResponse;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;

public class DTrackClient {
    private static final String DEPENDENCY_TRACK_API_KEY_HEADER = "X-Api-Key";
    private static final int DEFAULT_TIMEOUT = 30;
    private static final String API_V1 = "/api/v1/";
    private static final String API_UPLOAD_SCAN = "scan";
    private static final String API_UPLOAD_BOM = "bom";
    private static final String API_DOWNLOAD_BOM = "bom/cyclonedx/project/";
    private static final String API_TOKEN_PROCESSING = "bom/token/";
    private static final String API_PROJECT = "project";
    private static final String API_PROJECT_LOOKUP = "project/lookup";
    private static final String API_PROJECT_FINDINGS = "finding/project/";
    private static final String API_PROJECT_METRICS = "metrics/project/";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String dependencyTrackApiKey;
    private final Log log;
    private final CloseableHttpClient client;
    private final URI baseUri;

    public DTrackClient(String dependencyTrackUrl, String dependencyTrackApiKey, Log log) throws URISyntaxException {
        this.dependencyTrackApiKey = dependencyTrackApiKey;
        this.baseUri = new URI(dependencyTrackUrl).resolve(API_V1);
        this.log = log;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
        this.client = HttpClients.custom().setDefaultRequestConfig(config).setDefaultHeaders(this.apiHeaders()).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        log.info((CharSequence)("Using API v1 at: " + this.baseUri));
    }

    public List<Header> apiHeaders() {
        BasicHeader contentType = new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        BasicHeader apiKey = new BasicHeader(DEPENDENCY_TRACK_API_KEY_HEADER, this.dependencyTrackApiKey);
        ArrayList<Header> headersList = new ArrayList<Header>();
        headersList.add((Header)contentType);
        headersList.add((Header)apiKey);
        return headersList;
    }

    public void uploadScan(ScanSubmitRequest payload) throws IOException {
        URI uri = this.baseUri.resolve(API_UPLOAD_SCAN);
        String payloadAsString = this.objectMapper.writeValueAsString((Object)payload);
        HttpPut request = this.httpPut(uri, payloadAsString);
        this.log.info((CharSequence)("Uploading scan artifact to: {}" + uri));
        this.client.execute((HttpUriRequest)request, this.responseBodyHandler());
    }

    public TokenResponse uploadBom(BomSubmitRequest payload) throws IOException {
        URI uri = this.baseUri.resolve(API_UPLOAD_BOM);
        String payloadAsString = this.objectMapper.writeValueAsString((Object)payload);
        HttpPut request = this.httpPut(uri, payloadAsString);
        this.log.info((CharSequence)("Uploading bom artifact to: " + uri));
        TokenResponse response = (TokenResponse)this.client.execute((HttpUriRequest)request, this.responseBodyHandler(TokenResponse.class));
        this.log.info((CharSequence)("BOM response token: " + response.getToken()));
        return response;
    }

    public File downloadBom(UUID projectId, Path destinationPath) throws IOException {
        URI uri = this.baseUri.resolve(API_DOWNLOAD_BOM + projectId.toString());
        HttpGet request = this.httpGet(uri);
        return (File)this.client.execute((HttpUriRequest)request, this.downloadResponseHandler(destinationPath.toFile()));
    }

    public TokenProcessedResponse checkIfTokenIsBeingProcessed(UUID token) throws IOException {
        URI uri = this.baseUri.resolve(API_TOKEN_PROCESSING + token.toString());
        HttpGet request = this.httpGet(uri);
        return (TokenProcessedResponse)this.client.execute((HttpUriRequest)request, this.responseBodyHandler(TokenProcessedResponse.class));
    }

    public CompletableFuture<Boolean> pollTokenProcessing(UUID token, Executor executor) {
        Supplier<Boolean> checkToken = () -> {
            try {
                this.log.info((CharSequence)("Polling token [" + Instant.now() + "]: " + token));
                return this.checkIfTokenIsBeingProcessed(token).isProcessing();
            }
            catch (Exception e) {
                throw new CompletionException("Error during token polling", e);
            }
        };
        return CompletableFuture.supplyAsync(checkToken, executor).thenCompose(isProcessing -> {
            if (isProcessing.booleanValue()) {
                try {
                    this.log.info((CharSequence)"Token is still being processed, will retry in 5 seconds");
                    return this.pollTokenProcessing(token, CompletableFutureBackports.delayedExecutor(5L, TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    throw new CompletionException("Error during token polling", e);
                }
            }
            return CompletableFuture.completedFuture(isProcessing);
        });
    }

    public Project getProject(String name) throws IOException {
        URI uri = this.baseUri.resolve("project?name=" + name);
        HttpGet request = this.httpGet(uri);
        return (Project)this.client.execute((HttpUriRequest)request, this.responseBodyHandler(Project.class));
    }

    public Project getProject(String name, String version) throws IOException {
        URI uri = this.baseUri.resolve("project/lookup?name=" + name + "&version=" + version);
        HttpGet request = this.httpGet(uri);
        return (Project)this.client.execute((HttpUriRequest)request, this.responseBodyHandler(Project.class));
    }

    public List<Finding> getProjectFindings(UUID projectId) throws IOException {
        URI uri = this.baseUri.resolve(API_PROJECT_FINDINGS + projectId.toString());
        this.log.debug((CharSequence)("Invoking uri => " + uri.toString()));
        HttpGet request = this.httpGet(uri);
        Finding[] findings = (Finding[])this.client.execute((HttpUriRequest)request, this.responseBodyHandler(Finding[].class));
        return Arrays.asList(findings);
    }

    public ProjectMetrics getProjectMetrics(UUID projectId) throws IOException {
        URI uri = this.baseUri.resolve(API_PROJECT_METRICS + projectId.toString() + "/current");
        this.log.debug((CharSequence)("Invoking uri => " + uri.toString()));
        HttpGet request = this.httpGet(uri);
        return (ProjectMetrics)this.client.execute((HttpUriRequest)request, this.responseBodyHandler(ProjectMetrics.class));
    }

    private <R> ResponseHandler<R> responseBodyHandler(Class<R> responseType) {
        return response -> {
            this.processResponseStatus(response);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (responseString != null) {
                this.log.info((CharSequence)("Response string " + responseString));
                return this.objectMapper.readValue(responseString, responseType);
            }
            this.log.warn((CharSequence)"Unable to find response string, returning null ");
            return null;
        };
    }

    private <R> ResponseHandler<R> responseBodyHandler() {
        return response -> {
            this.processResponseStatus(response);
            return null;
        };
    }

    private ResponseHandler<File> downloadResponseHandler(File target) {
        return response -> {
            InputStreamFacade source = () -> response.getEntity().getContent();
            FileUtils.copyStreamToFile((InputStreamFacade)source, (File)target);
            return target;
        };
    }

    private void processResponseStatus(HttpResponse response) throws HttpResponseException {
        StatusLine statusLine = response.getStatusLine();
        this.logResponseCode(statusLine.getStatusCode());
        if (statusLine.getStatusCode() >= 300) {
            this.handleNonSuccessCode(response);
        }
    }

    private void handleNonSuccessCode(HttpResponse response) throws HttpResponseException {
        String detail;
        StatusLine statusLine = response.getStatusLine();
        try {
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            detail = String.format("[%s] %s", statusLine.getReasonPhrase(), body);
        }
        catch (Exception e) {
            detail = statusLine.getReasonPhrase();
        }
        throw new HttpResponseException(statusLine.getStatusCode(), detail);
    }

    private void logResponseCode(int statusCode) {
        switch (statusCode) {
            case 200: {
                this.log.debug((CharSequence)"Request successful");
                break;
            }
            case 400: {
                this.log.error((CharSequence)"Bad request. Probably an error in the plugin itself.");
                break;
            }
            case 401: {
                this.log.error((CharSequence)"Unauthenticated. Check your API Key");
                break;
            }
            case 403: {
                this.log.error((CharSequence)"Unauthorized. Check the permissions of the provided API Key. Required are: SCAN_UPLOAD and either PROJECT_CREATION_UPLOAD or PORTFOLIO_MANAGEMENT");
                break;
            }
            default: {
                this.log.warn((CharSequence)("Received status code: " + statusCode));
            }
        }
    }

    private HttpPut httpPut(URI uri, String body) {
        HttpPut request = new HttpPut();
        request.setURI(uri);
        request.setEntity(EntityBuilder.create().setText(body).build());
        return request;
    }

    private HttpGet httpGet(URI uri) {
        HttpGet request = new HttpGet();
        request.setURI(uri);
        return request;
    }
}

