/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack.client.model;

import iabudiab.maven.plugins.dependencytrack.client.model.Analysis;
import iabudiab.maven.plugins.dependencytrack.client.model.Finding;
import iabudiab.maven.plugins.dependencytrack.client.model.State;
import java.util.List;
import java.util.Optional;

public class FindingsReport {
    private List<Finding> findings;
    private int falsePositives = 0;
    private int notAffected = 0;
    private int suppressed = 0;

    public FindingsReport(List<Finding> findings) {
        this.findings = findings;
    }

    public CharSequence printSummary() {
        StringBuilder builder = new StringBuilder();
        builder.append("--- Findings report ---");
        builder.append("\n");
        if (this.findings.isEmpty()) {
            builder.append("+ Nothing to report!");
            return builder.toString();
        }
        for (Finding finding : this.findings) {
            Analysis analysis = finding.getAnalysis();
            if (this.checkAnalysis(analysis)) continue;
            builder.append("-  Component    : " + finding.getComponent().getPurl());
            builder.append("\n");
            builder.append("   Vulnerability: " + finding.getVulnerability().reportSummary());
            builder.append("\n");
            builder.append("   Analysis     : " + (Object)((Object)Optional.ofNullable(finding.getAnalysis()).map(Analysis::getState).orElse(State.NOT_SET)));
            builder.append("\n");
        }
        builder.append("+ False positives : " + this.falsePositives);
        builder.append("\n");
        builder.append("+ Not affected    : " + this.notAffected);
        builder.append("\n");
        builder.append("+ Suppressed      : " + this.suppressed);
        builder.append("\n");
        return builder.toString();
    }

    private boolean checkAnalysis(Analysis analysis) {
        boolean shouldIgnore = false;
        if (analysis.isSuppressed()) {
            ++this.suppressed;
            shouldIgnore = true;
        }
        if (analysis.getState() == State.FALSE_POSITIVE) {
            ++this.falsePositives;
            shouldIgnore = true;
        }
        if (analysis.getState() == State.NOT_AFFECTED) {
            ++this.notAffected;
            shouldIgnore = true;
        }
        return shouldIgnore;
    }
}

