/*
 * Decompiled with CFR 0.152.
 */
package iabudiab.maven.plugins.dependencytrack.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectMetrics {
    private int critical;
    private int high;
    private int medium;
    private int low;
    private int unassigned;
    private long vulnerabilities;
    private int vulnerableComponents;
    private int components;
    private int suppressed;
    private int findingsTotal;
    private int findingsAudited;
    private int findingsUnaudited;
    private double inheritedRiskScore;
    private long firstOccurrence;
    private long lastOccurrence;

    public CharSequence printMetrics() {
        StringBuilder builder = new StringBuilder();
        builder.append("--- Project Metrics ---");
        builder.append("\n");
        builder.append("critical: ");
        builder.append(this.critical);
        builder.append(", high: ");
        builder.append(this.high);
        builder.append(", medium: ");
        builder.append(this.medium);
        builder.append(", low: ");
        builder.append(this.low);
        return builder.toString();
    }

    public int getCritical() {
        return this.critical;
    }

    public int getHigh() {
        return this.high;
    }

    public int getMedium() {
        return this.medium;
    }

    public int getLow() {
        return this.low;
    }

    public int getUnassigned() {
        return this.unassigned;
    }

    public long getVulnerabilities() {
        return this.vulnerabilities;
    }

    public int getVulnerableComponents() {
        return this.vulnerableComponents;
    }

    public int getComponents() {
        return this.components;
    }

    public int getSuppressed() {
        return this.suppressed;
    }

    public int getFindingsTotal() {
        return this.findingsTotal;
    }

    public int getFindingsAudited() {
        return this.findingsAudited;
    }

    public int getFindingsUnaudited() {
        return this.findingsUnaudited;
    }

    public double getInheritedRiskScore() {
        return this.inheritedRiskScore;
    }

    public long getFirstOccurrence() {
        return this.firstOccurrence;
    }

    public long getLastOccurrence() {
        return this.lastOccurrence;
    }

    public void setCritical(int critical) {
        this.critical = critical;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public void setMedium(int medium) {
        this.medium = medium;
    }

    public void setLow(int low) {
        this.low = low;
    }

    public void setUnassigned(int unassigned) {
        this.unassigned = unassigned;
    }

    public void setVulnerabilities(long vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    public void setVulnerableComponents(int vulnerableComponents) {
        this.vulnerableComponents = vulnerableComponents;
    }

    public void setComponents(int components) {
        this.components = components;
    }

    public void setSuppressed(int suppressed) {
        this.suppressed = suppressed;
    }

    public void setFindingsTotal(int findingsTotal) {
        this.findingsTotal = findingsTotal;
    }

    public void setFindingsAudited(int findingsAudited) {
        this.findingsAudited = findingsAudited;
    }

    public void setFindingsUnaudited(int findingsUnaudited) {
        this.findingsUnaudited = findingsUnaudited;
    }

    public void setInheritedRiskScore(double inheritedRiskScore) {
        this.inheritedRiskScore = inheritedRiskScore;
    }

    public void setFirstOccurrence(long firstOccurrence) {
        this.firstOccurrence = firstOccurrence;
    }

    public void setLastOccurrence(long lastOccurrence) {
        this.lastOccurrence = lastOccurrence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectMetrics)) {
            return false;
        }
        ProjectMetrics other = (ProjectMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCritical() != other.getCritical()) {
            return false;
        }
        if (this.getHigh() != other.getHigh()) {
            return false;
        }
        if (this.getMedium() != other.getMedium()) {
            return false;
        }
        if (this.getLow() != other.getLow()) {
            return false;
        }
        if (this.getUnassigned() != other.getUnassigned()) {
            return false;
        }
        if (this.getVulnerabilities() != other.getVulnerabilities()) {
            return false;
        }
        if (this.getVulnerableComponents() != other.getVulnerableComponents()) {
            return false;
        }
        if (this.getComponents() != other.getComponents()) {
            return false;
        }
        if (this.getSuppressed() != other.getSuppressed()) {
            return false;
        }
        if (this.getFindingsTotal() != other.getFindingsTotal()) {
            return false;
        }
        if (this.getFindingsAudited() != other.getFindingsAudited()) {
            return false;
        }
        if (this.getFindingsUnaudited() != other.getFindingsUnaudited()) {
            return false;
        }
        if (Double.compare(this.getInheritedRiskScore(), other.getInheritedRiskScore()) != 0) {
            return false;
        }
        if (this.getFirstOccurrence() != other.getFirstOccurrence()) {
            return false;
        }
        return this.getLastOccurrence() == other.getLastOccurrence();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectMetrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCritical();
        result = result * 59 + this.getHigh();
        result = result * 59 + this.getMedium();
        result = result * 59 + this.getLow();
        result = result * 59 + this.getUnassigned();
        long $vulnerabilities = this.getVulnerabilities();
        result = result * 59 + (int)($vulnerabilities >>> 32 ^ $vulnerabilities);
        result = result * 59 + this.getVulnerableComponents();
        result = result * 59 + this.getComponents();
        result = result * 59 + this.getSuppressed();
        result = result * 59 + this.getFindingsTotal();
        result = result * 59 + this.getFindingsAudited();
        result = result * 59 + this.getFindingsUnaudited();
        long $inheritedRiskScore = Double.doubleToLongBits(this.getInheritedRiskScore());
        result = result * 59 + (int)($inheritedRiskScore >>> 32 ^ $inheritedRiskScore);
        long $firstOccurrence = this.getFirstOccurrence();
        result = result * 59 + (int)($firstOccurrence >>> 32 ^ $firstOccurrence);
        long $lastOccurrence = this.getLastOccurrence();
        result = result * 59 + (int)($lastOccurrence >>> 32 ^ $lastOccurrence);
        return result;
    }

    public String toString() {
        return "ProjectMetrics(critical=" + this.getCritical() + ", high=" + this.getHigh() + ", medium=" + this.getMedium() + ", low=" + this.getLow() + ", unassigned=" + this.getUnassigned() + ", vulnerabilities=" + this.getVulnerabilities() + ", vulnerableComponents=" + this.getVulnerableComponents() + ", components=" + this.getComponents() + ", suppressed=" + this.getSuppressed() + ", findingsTotal=" + this.getFindingsTotal() + ", findingsAudited=" + this.getFindingsAudited() + ", findingsUnaudited=" + this.getFindingsUnaudited() + ", inheritedRiskScore=" + this.getInheritedRiskScore() + ", firstOccurrence=" + this.getFirstOccurrence() + ", lastOccurrence=" + this.getLastOccurrence() + ")";
    }
}

