/*
 * Decompiled with CFR 0.152.
 */
package dev.icerock.moko.graphics;

import dev.icerock.moko.graphics.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"parseColor", "Ldev/icerock/moko/graphics/Color;", "Ldev/icerock/moko/graphics/Color$Companion;", "colorHEX", "", "graphics_release"})
public final class ColorHEXKt {
    @NotNull
    public static final Color parseColor(@NotNull Color.Companion $this$parseColor, @NotNull String colorHEX) {
        Intrinsics.checkNotNullParameter((Object)$this$parseColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)colorHEX, (String)"colorHEX");
        if (colorHEX.charAt(0) != '#') {
            throw new IllegalArgumentException("Unknown color");
        }
        String string = colorHEX.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        long colorARGB = Long.parseLong(string, CharsKt.checkRadix((int)16));
        if (colorHEX.length() == 7) {
            colorARGB |= 0xFF000000L;
        } else if (colorHEX.length() != 9) {
            throw new IllegalArgumentException("Unknown color");
        }
        int n = (int)(colorARGB >> 24 & 0xFFL);
        int n2 = (int)(colorARGB >> 16 & 0xFFL);
        int n3 = (int)(colorARGB >> 8 & 0xFFL);
        int n4 = (int)(colorARGB >> 0 & 0xFFL);
        return new Color(n2, n3, n4, n);
    }
}

