/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.interfaces.ElkAnnotation;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationSubject;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationValue;
import org.semanticweb.elk.owl.interfaces.ElkAnonymousIndividual;
import org.semanticweb.elk.owl.interfaces.ElkAsymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkDataIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataOneOf;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataRange;
import org.semanticweb.elk.owl.interfaces.ElkDataSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeDefinitionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeRestriction;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointUnionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFacetRestriction;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalDataPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkHasKeyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkInverseObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIrreflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkLiteral;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNegativeDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasSelf;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectInverseOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSWRLRule;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubAnnotationPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubDataPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.iris.ElkAbbreviatedIri;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.visitors.ElkObjectVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWLFacet;

public abstract class AbstractElkObjectConverter
implements ElkObjectVisitor<OWLObject> {
    private final OWLDataFactory owlFactory_;

    public AbstractElkObjectConverter() {
        this(OWLManager.getOWLDataFactory());
    }

    public AbstractElkObjectConverter(OWLDataFactory owlFactory) {
        this.owlFactory_ = owlFactory;
    }

    abstract OWLAnnotationProperty convert(ElkAnnotationProperty var1);

    abstract OWLAnnotationSubject convert(ElkAnnotationSubject var1);

    abstract OWLAnnotationValue convert(ElkAnnotationValue var1);

    abstract OWLAxiom convert(ElkAxiom var1);

    abstract OWLClass convert(ElkClass var1);

    abstract OWLClassExpression convert(ElkClassExpression var1);

    abstract OWLDataProperty convert(ElkDataProperty var1);

    abstract OWLDataPropertyExpression convert(ElkDataPropertyExpression var1);

    abstract OWLDataRange convert(ElkDataRange var1);

    abstract OWLDatatype convert(ElkDatatype var1);

    abstract OWLEntity convert(ElkEntity var1);

    abstract OWLFacetRestriction convert(ElkFacetRestriction var1);

    abstract OWLIndividual convert(ElkIndividual var1);

    abstract IRI convert(ElkIri var1);

    abstract OWLLiteral convert(ElkLiteral var1);

    abstract OWLNamedIndividual convert(ElkNamedIndividual var1);

    abstract OWLObjectProperty convert(ElkObjectProperty var1);

    abstract OWLObjectPropertyExpression convert(ElkObjectPropertyExpression var1);

    Set<OWLClassExpression> toClassExpressionSet(List<? extends ElkClassExpression> input) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>(input.size());
        for (ElkClassExpression elkClassExpression : input) {
            result.add(this.convert(elkClassExpression));
        }
        return result;
    }

    Set<OWLDataPropertyExpression> toDataPropertyExpressionSet(List<? extends ElkDataPropertyExpression> input) {
        HashSet<OWLDataPropertyExpression> result = new HashSet<OWLDataPropertyExpression>(input.size());
        for (ElkDataPropertyExpression elkDataPropertyExpression : input) {
            result.add(this.convert(elkDataPropertyExpression));
        }
        return result;
    }

    Set<OWLDataRange> toDataRangeSet(List<? extends ElkDataRange> input) {
        HashSet<OWLDataRange> result = new HashSet<OWLDataRange>(input.size());
        for (ElkDataRange elkDataRange : input) {
            result.add(this.convert(elkDataRange));
        }
        return result;
    }

    Set<OWLFacetRestriction> toFacetRestrictionSet(List<? extends ElkFacetRestriction> input) {
        HashSet<OWLFacetRestriction> result = new HashSet<OWLFacetRestriction>(input.size());
        for (ElkFacetRestriction elkFacetRestriction : input) {
            result.add(this.convert(elkFacetRestriction));
        }
        return result;
    }

    Set<OWLIndividual> toIndividualSet(List<? extends ElkIndividual> input) {
        HashSet<OWLIndividual> result = new HashSet<OWLIndividual>(input.size());
        for (ElkIndividual elkIndividual : input) {
            result.add(this.convert(elkIndividual));
        }
        return result;
    }

    Set<OWLLiteral> toLiteralSet(List<? extends ElkLiteral> input) {
        HashSet<OWLLiteral> result = new HashSet<OWLLiteral>(input.size());
        for (ElkLiteral elkLiteral : input) {
            result.add(this.convert(elkLiteral));
        }
        return result;
    }

    Set<OWLObjectPropertyExpression> toObjectPropertyExpressionSet(List<? extends ElkObjectPropertyExpression> input) {
        HashSet<OWLObjectPropertyExpression> result = new HashSet<OWLObjectPropertyExpression>(input.size());
        for (ElkObjectPropertyExpression elkObjectPropertyExpression : input) {
            result.add(this.convert(elkObjectPropertyExpression));
        }
        return result;
    }

    List<? extends OWLObjectPropertyExpression> toPropertyExpressionList(List<? extends ElkObjectPropertyExpression> input) {
        ArrayList<OWLObjectPropertyExpression> result = new ArrayList<OWLObjectPropertyExpression>(input.size());
        for (ElkObjectPropertyExpression elkObjectPropertyExpression : input) {
            result.add(this.convert(elkObjectPropertyExpression));
        }
        return result;
    }

    Set<? extends OWLPropertyExpression> toPropertyExpressionSet(List<? extends ElkObjectPropertyExpression> objectProperties, List<? extends ElkDataPropertyExpression> dataProperties) {
        HashSet<Object> result = new HashSet<Object>(objectProperties.size() + dataProperties.size());
        for (ElkObjectPropertyExpression elkObjectPropertyExpression : objectProperties) {
            result.add(this.convert(elkObjectPropertyExpression));
        }
        for (ElkDataPropertyExpression elkDataPropertyExpression : dataProperties) {
            result.add(this.convert(elkDataPropertyExpression));
        }
        return result;
    }

    public IRI visit(ElkAbbreviatedIri iri) {
        return IRI.create((String)iri.getPrefix().getIri().getFullIriAsString(), (String)iri.getLocalName());
    }

    public OWLAnnotation visit(ElkAnnotation annotation) {
        return this.owlFactory_.getOWLAnnotation(this.convert(annotation.getProperty()), this.convert(annotation.getValue()));
    }

    public OWLAnnotationAssertionAxiom visit(ElkAnnotationAssertionAxiom axiom) {
        return this.owlFactory_.getOWLAnnotationAssertionAxiom(this.convert(axiom.getProperty()), this.convert(axiom.getSubject()), this.convert(axiom.getValue()));
    }

    public OWLAnnotationProperty visit(ElkAnnotationProperty expression) {
        return this.owlFactory_.getOWLAnnotationProperty(this.convert(expression.getIri()));
    }

    public OWLAnnotationPropertyDomainAxiom visit(ElkAnnotationPropertyDomainAxiom axiom) {
        return this.owlFactory_.getOWLAnnotationPropertyDomainAxiom(this.convert((ElkAnnotationProperty)axiom.getProperty()), this.convert((ElkIri)axiom.getDomain()));
    }

    public OWLAnnotationPropertyRangeAxiom visit(ElkAnnotationPropertyRangeAxiom axiom) {
        return this.owlFactory_.getOWLAnnotationPropertyRangeAxiom(this.convert((ElkAnnotationProperty)axiom.getProperty()), this.convert((ElkIri)axiom.getRange()));
    }

    public OWLAnonymousIndividual visit(ElkAnonymousIndividual expression) {
        return this.owlFactory_.getOWLAnonymousIndividual(expression.getNodeId());
    }

    public OWLAsymmetricObjectPropertyAxiom visit(ElkAsymmetricObjectPropertyAxiom axiom) {
        return this.owlFactory_.getOWLAsymmetricObjectPropertyAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLClass visit(ElkClass expression) {
        return this.owlFactory_.getOWLClass(this.convert(expression.getIri()));
    }

    public OWLClassAssertionAxiom visit(ElkClassAssertionAxiom axiom) {
        return this.owlFactory_.getOWLClassAssertionAxiom(this.convert(axiom.getClassExpression()), this.convert(axiom.getIndividual()));
    }

    public OWLDataAllValuesFrom visit(ElkDataAllValuesFrom expression) {
        List expressions = expression.getDataPropertyExpressions();
        if (expressions.size() > 0) {
            throw new IllegalArgumentException("OWLAPI supports only one data property in OWLDataAllValuesFrom");
        }
        return this.owlFactory_.getOWLDataAllValuesFrom(this.convert((ElkDataPropertyExpression)expressions.get(0)), this.convert(expression.getDataRange()));
    }

    public OWLDataComplementOf visit(ElkDataComplementOf expression) {
        return this.owlFactory_.getOWLDataComplementOf(this.convert((ElkDataRange)expression));
    }

    public OWLDataExactCardinality visit(ElkDataExactCardinalityQualified expression) {
        return this.owlFactory_.getOWLDataExactCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()), this.convert((ElkDataRange)expression.getFiller()));
    }

    public OWLDataExactCardinality visit(ElkDataExactCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLDataExactCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()));
    }

    public OWLDataHasValue visit(ElkDataHasValue expression) {
        return this.owlFactory_.getOWLDataHasValue(this.convert((ElkDataPropertyExpression)expression.getProperty()), this.convert((ElkLiteral)expression.getFiller()));
    }

    public OWLDataIntersectionOf visit(ElkDataIntersectionOf expression) {
        return this.owlFactory_.getOWLDataIntersectionOf(this.toDataRangeSet(expression.getDataRanges()));
    }

    public OWLDataMaxCardinality visit(ElkDataMaxCardinalityQualified expression) {
        return this.owlFactory_.getOWLDataMaxCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()), this.convert((ElkDataRange)expression.getFiller()));
    }

    public OWLDataMaxCardinality visit(ElkDataMaxCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLDataMaxCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()));
    }

    public OWLDataMinCardinality visit(ElkDataMinCardinalityQualified expression) {
        return this.owlFactory_.getOWLDataMinCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()), this.convert((ElkDataRange)expression.getFiller()));
    }

    public OWLDataMinCardinality visit(ElkDataMinCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLDataMinCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()));
    }

    public OWLDataOneOf visit(ElkDataOneOf expression) {
        return this.owlFactory_.getOWLDataOneOf(this.toLiteralSet(expression.getLiterals()));
    }

    public OWLDataProperty visit(ElkDataProperty expression) {
        return this.owlFactory_.getOWLDataProperty(this.convert(expression.getIri()));
    }

    public OWLDataPropertyAssertionAxiom visit(ElkDataPropertyAssertionAxiom axiom) {
        return this.owlFactory_.getOWLDataPropertyAssertionAxiom(this.convert((ElkDataPropertyExpression)axiom.getProperty()), this.convert((ElkIndividual)axiom.getSubject()), this.convert((ElkLiteral)axiom.getObject()));
    }

    public OWLDataPropertyDomainAxiom visit(ElkDataPropertyDomainAxiom axiom) {
        return this.owlFactory_.getOWLDataPropertyDomainAxiom(this.convert((ElkDataPropertyExpression)axiom.getProperty()), this.convert((ElkClassExpression)axiom.getDomain()));
    }

    public OWLDataPropertyRangeAxiom visit(ElkDataPropertyRangeAxiom axiom) {
        return this.owlFactory_.getOWLDataPropertyRangeAxiom(this.convert((ElkDataPropertyExpression)axiom.getProperty()), this.convert((ElkDataRange)axiom.getRange()));
    }

    public OWLDataSomeValuesFrom visit(ElkDataSomeValuesFrom expression) {
        List propertyExpressions = expression.getDataPropertyExpressions();
        if (propertyExpressions.size() > 0) {
            throw new IllegalArgumentException("OWLAPI supports only one data property in OWLDataSomeValuesFrom");
        }
        return this.owlFactory_.getOWLDataSomeValuesFrom(this.convert((ElkDataPropertyExpression)propertyExpressions.get(0)), this.convert(expression.getDataRange()));
    }

    public OWLDatatype visit(ElkDatatype expression) {
        return this.owlFactory_.getOWLDatatype(this.convert(expression.getIri()));
    }

    public OWLDatatypeDefinitionAxiom visit(ElkDatatypeDefinitionAxiom axiom) {
        return this.owlFactory_.getOWLDatatypeDefinitionAxiom(this.convert(axiom.getDatatype()), this.convert(axiom.getDataRange()));
    }

    public OWLDatatypeRestriction visit(ElkDatatypeRestriction expression) {
        return this.owlFactory_.getOWLDatatypeRestriction(this.convert(expression.getDatatype()), this.toFacetRestrictionSet(expression.getFacetRestrictions()));
    }

    public OWLDataUnionOf visit(ElkDataUnionOf expression) {
        return this.owlFactory_.getOWLDataUnionOf(this.toDataRangeSet(expression.getDataRanges()));
    }

    public OWLDeclarationAxiom visit(ElkDeclarationAxiom axiom) {
        return this.owlFactory_.getOWLDeclarationAxiom(this.convert(axiom.getEntity()));
    }

    public OWLDifferentIndividualsAxiom visit(ElkDifferentIndividualsAxiom axiom) {
        return this.owlFactory_.getOWLDifferentIndividualsAxiom(this.toIndividualSet(axiom.getIndividuals()));
    }

    public OWLDisjointClassesAxiom visit(ElkDisjointClassesAxiom axiom) {
        return this.owlFactory_.getOWLDisjointClassesAxiom(this.toClassExpressionSet(axiom.getClassExpressions()));
    }

    public OWLDisjointDataPropertiesAxiom visit(ElkDisjointDataPropertiesAxiom axiom) {
        return this.owlFactory_.getOWLDisjointDataPropertiesAxiom(this.toDataPropertyExpressionSet(axiom.getDataPropertyExpressions()));
    }

    public OWLDisjointObjectPropertiesAxiom visit(ElkDisjointObjectPropertiesAxiom axiom) {
        return this.owlFactory_.getOWLDisjointObjectPropertiesAxiom(this.toObjectPropertyExpressionSet(axiom.getObjectPropertyExpressions()));
    }

    public OWLDisjointUnionAxiom visit(ElkDisjointUnionAxiom axiom) {
        return this.owlFactory_.getOWLDisjointUnionAxiom(this.convert(axiom.getDefinedClass()), this.toClassExpressionSet(axiom.getClassExpressions()));
    }

    public OWLEquivalentClassesAxiom visit(ElkEquivalentClassesAxiom axiom) {
        return this.owlFactory_.getOWLEquivalentClassesAxiom(this.toClassExpressionSet(axiom.getClassExpressions()));
    }

    public OWLEquivalentDataPropertiesAxiom visit(ElkEquivalentDataPropertiesAxiom axiom) {
        return this.owlFactory_.getOWLEquivalentDataPropertiesAxiom(this.toDataPropertyExpressionSet(axiom.getDataPropertyExpressions()));
    }

    public OWLEquivalentObjectPropertiesAxiom visit(ElkEquivalentObjectPropertiesAxiom axiom) {
        return this.owlFactory_.getOWLEquivalentObjectPropertiesAxiom(this.toObjectPropertyExpressionSet(axiom.getObjectPropertyExpressions()));
    }

    public OWLFacetRestriction visit(ElkFacetRestriction restriction) {
        return this.owlFactory_.getOWLFacetRestriction(OWLFacet.getFacet((IRI)this.convert(restriction.getConstrainingFacet())), this.convert(restriction.getRestrictionValue()));
    }

    public IRI visit(ElkFullIri iri) {
        return IRI.create((String)iri.getFullIriAsString());
    }

    public OWLFunctionalDataPropertyAxiom visit(ElkFunctionalDataPropertyAxiom axiom) {
        return this.owlFactory_.getOWLFunctionalDataPropertyAxiom(this.convert((ElkDataPropertyExpression)axiom.getProperty()));
    }

    public OWLFunctionalObjectPropertyAxiom visit(ElkFunctionalObjectPropertyAxiom axiom) {
        return this.owlFactory_.getOWLFunctionalObjectPropertyAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLHasKeyAxiom visit(ElkHasKeyAxiom axiom) {
        return this.owlFactory_.getOWLHasKeyAxiom(this.convert(axiom.getClassExpression()), this.toPropertyExpressionSet(axiom.getObjectPropertyExpressions(), axiom.getDataPropertyExpressions()));
    }

    public OWLInverseFunctionalObjectPropertyAxiom visit(ElkInverseFunctionalObjectPropertyAxiom axiom) {
        return this.owlFactory_.getOWLInverseFunctionalObjectPropertyAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLInverseObjectPropertiesAxiom visit(ElkInverseObjectPropertiesAxiom axiom) {
        return this.owlFactory_.getOWLInverseObjectPropertiesAxiom(this.convert(axiom.getFirstObjectPropertyExpression()), this.convert(axiom.getSecondObjectPropertyExpression()));
    }

    public OWLIrreflexiveObjectPropertyAxiom visit(ElkIrreflexiveObjectPropertyAxiom axiom) {
        return this.owlFactory_.getOWLIrreflexiveObjectPropertyAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLLiteral visit(ElkLiteral expression) {
        return this.owlFactory_.getOWLLiteral(expression.getLexicalForm(), this.convert(expression.getDatatype()));
    }

    public OWLNamedIndividual visit(ElkNamedIndividual expression) {
        return this.owlFactory_.getOWLNamedIndividual(this.convert(expression.getIri()));
    }

    public OWLNegativeDataPropertyAssertionAxiom visit(ElkNegativeDataPropertyAssertionAxiom axiom) {
        return this.owlFactory_.getOWLNegativeDataPropertyAssertionAxiom(this.convert((ElkDataPropertyExpression)axiom.getProperty()), this.convert((ElkIndividual)axiom.getSubject()), this.convert((ElkLiteral)axiom.getObject()));
    }

    public OWLNegativeObjectPropertyAssertionAxiom visit(ElkNegativeObjectPropertyAssertionAxiom axiom) {
        return this.owlFactory_.getOWLNegativeObjectPropertyAssertionAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()), this.convert((ElkIndividual)axiom.getSubject()), this.convert((ElkIndividual)axiom.getObject()));
    }

    public OWLObjectAllValuesFrom visit(ElkObjectAllValuesFrom expression) {
        return this.owlFactory_.getOWLObjectAllValuesFrom(this.convert((ElkObjectPropertyExpression)expression.getProperty()), this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectComplementOf visit(ElkObjectComplementOf expression) {
        return this.owlFactory_.getOWLObjectComplementOf(this.convert(expression.getClassExpression()));
    }

    public OWLObjectExactCardinality visit(ElkObjectExactCardinalityQualified expression) {
        return this.owlFactory_.getOWLObjectExactCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectExactCardinality visit(ElkObjectExactCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLObjectExactCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectHasSelf visit(ElkObjectHasSelf expression) {
        return this.owlFactory_.getOWLObjectHasSelf(this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectHasValue visit(ElkObjectHasValue expression) {
        return this.owlFactory_.getOWLObjectHasValue(this.convert((ElkObjectPropertyExpression)expression.getProperty()), this.convert((ElkIndividual)expression.getFiller()));
    }

    public OWLObjectIntersectionOf visit(ElkObjectIntersectionOf expression) {
        return this.owlFactory_.getOWLObjectIntersectionOf(this.toClassExpressionSet(expression.getClassExpressions()));
    }

    public OWLObjectInverseOf visit(ElkObjectInverseOf expression) {
        return this.owlFactory_.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.convert(expression.getObjectProperty()));
    }

    public OWLObjectMaxCardinality visit(ElkObjectMaxCardinalityQualified expression) {
        return this.owlFactory_.getOWLObjectMaxCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()), this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectMaxCardinality visit(ElkObjectMaxCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLObjectMaxCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectMinCardinality visit(ElkObjectMinCardinalityQualified expression) {
        return this.owlFactory_.getOWLObjectMinCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()), this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectMinCardinality visit(ElkObjectMinCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLObjectMinCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectOneOf visit(ElkObjectOneOf expression) {
        return this.owlFactory_.getOWLObjectOneOf(this.toIndividualSet(expression.getIndividuals()));
    }

    public OWLObjectProperty visit(ElkObjectProperty expression) {
        return this.owlFactory_.getOWLObjectProperty(this.convert(expression.getIri()));
    }

    public OWLObjectPropertyAssertionAxiom visit(ElkObjectPropertyAssertionAxiom axiom) {
        return this.owlFactory_.getOWLObjectPropertyAssertionAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()), this.convert((ElkIndividual)axiom.getSubject()), this.convert((ElkIndividual)axiom.getObject()));
    }

    public OWLObject visit(ElkObjectPropertyChain expression) {
        throw new ElkRuntimeException("ElkObjectPropertyChain cannot convert to OWLObject");
    }

    public OWLObjectPropertyDomainAxiom visit(ElkObjectPropertyDomainAxiom axiom) {
        return this.owlFactory_.getOWLObjectPropertyDomainAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()), this.convert((ElkClassExpression)axiom.getDomain()));
    }

    public OWLObjectPropertyRangeAxiom visit(ElkObjectPropertyRangeAxiom axiom) {
        return this.owlFactory_.getOWLObjectPropertyRangeAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()), this.convert((ElkClassExpression)axiom.getRange()));
    }

    public OWLObjectSomeValuesFrom visit(ElkObjectSomeValuesFrom expression) {
        return this.owlFactory_.getOWLObjectSomeValuesFrom(this.convert((ElkObjectPropertyExpression)expression.getProperty()), this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectUnionOf visit(ElkObjectUnionOf expression) {
        return this.owlFactory_.getOWLObjectUnionOf(this.toClassExpressionSet(expression.getClassExpressions()));
    }

    public OWLReflexiveObjectPropertyAxiom visit(ElkReflexiveObjectPropertyAxiom axiom) {
        return this.owlFactory_.getOWLReflexiveObjectPropertyAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLSameIndividualAxiom visit(ElkSameIndividualAxiom axiom) {
        return this.owlFactory_.getOWLSameIndividualAxiom(this.toIndividualSet(axiom.getIndividuals()));
    }

    public OWLSubAnnotationPropertyOfAxiom visit(ElkSubAnnotationPropertyOfAxiom axiom) {
        return this.owlFactory_.getOWLSubAnnotationPropertyOfAxiom(this.convert(axiom.getSubAnnotationProperty()), this.convert(axiom.getSuperAnnotationProperty()));
    }

    public OWLObject visit(ElkSubClassOfAxiom axiom) {
        return this.owlFactory_.getOWLSubClassOfAxiom(this.convert(axiom.getSubClassExpression()), this.convert(axiom.getSuperClassExpression()));
    }

    public OWLSubDataPropertyOfAxiom visit(ElkSubDataPropertyOfAxiom axiom) {
        return this.owlFactory_.getOWLSubDataPropertyOfAxiom(this.convert(axiom.getSubDataPropertyExpression()), this.convert(axiom.getSuperDataPropertyExpression()));
    }

    public OWLObjectPropertyAxiom visit(final ElkSubObjectPropertyOfAxiom axiom) {
        return (OWLObjectPropertyAxiom)axiom.getSubObjectPropertyExpression().accept((ElkSubObjectPropertyExpressionVisitor)new ElkSubObjectPropertyExpressionVisitor<OWLObjectPropertyAxiom>(){

            OWLSubObjectPropertyOfAxiom defaultVisit(ElkObjectPropertyExpression subExpression) {
                return AbstractElkObjectConverter.this.owlFactory_.getOWLSubObjectPropertyOfAxiom(AbstractElkObjectConverter.this.convert(subExpression), AbstractElkObjectConverter.this.convert(axiom.getSuperObjectPropertyExpression()));
            }

            public OWLSubObjectPropertyOfAxiom visit(ElkObjectInverseOf expression) {
                return this.defaultVisit((ElkObjectPropertyExpression)expression);
            }

            public OWLSubObjectPropertyOfAxiom visit(ElkObjectProperty expression) {
                return this.defaultVisit((ElkObjectPropertyExpression)expression);
            }

            public OWLSubPropertyChainOfAxiom visit(ElkObjectPropertyChain subExpression) {
                return AbstractElkObjectConverter.this.owlFactory_.getOWLSubPropertyChainOfAxiom(AbstractElkObjectConverter.this.toPropertyExpressionList(subExpression.getObjectPropertyExpressions()), AbstractElkObjectConverter.this.convert(axiom.getSuperObjectPropertyExpression()));
            }
        });
    }

    public OWLObject visit(ElkSWRLRule axiom) {
        throw new ElkRuntimeException("SWRL rules not supported by ELK");
    }

    public OWLSymmetricObjectPropertyAxiom visit(ElkSymmetricObjectPropertyAxiom axiom) {
        return this.owlFactory_.getOWLSymmetricObjectPropertyAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLTransitiveObjectPropertyAxiom visit(ElkTransitiveObjectPropertyAxiom axiom) {
        return this.owlFactory_.getOWLTransitiveObjectPropertyAxiom(this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }
}

