/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owlapi.ElkConverter;
import org.semanticweb.elk.owlapi.ElkReasonerConfiguration;
import org.semanticweb.elk.owlapi.ElkReasonerProgressMonitor;
import org.semanticweb.elk.owlapi.OwlChangesLoaderFactory;
import org.semanticweb.elk.owlapi.OwlOntologyLoader;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkUnsupportedReasoningTaskException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerFactory;
import org.semanticweb.elk.reasoner.completeness.IncompleteResult;
import org.semanticweb.elk.reasoner.completeness.Incompleteness;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.query.EntailmentQueryConverter;
import org.semanticweb.elk.reasoner.query.QueryResult;
import org.semanticweb.elk.reasoner.query.VerifiableQueryResult;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.util.logging.LogLevel;
import org.semanticweb.elk.util.logging.LoggerWrap;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ElkReasoner
implements OWLReasoner {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ElkReasoner.class);
    private static final Marker MARKER_UNSUPPORTED_METHOD_ = MarkerFactory.getMarker((String)"owlapi.unsupportedMethod");
    private final OWLOntology owlOntology_;
    private final OWLOntologyManager owlOntologymanager_;
    private final ProgressMonitor mainProgressMonitor_;
    private final ProgressMonitor secondaryProgressMonitor_;
    private final boolean isBufferingMode_;
    private final OntologyChangeListener ontologyChangeListener_;
    private final OntologyChangeProgressListener ontologyChangeProgressListener_;
    private final ElkObject.Factory objectFactory_;
    private final OwlConverter owlConverter_;
    private final ElkConverter elkConverter_;
    private volatile OwlChangesLoaderFactory bufferedChangesLoader_;
    private ReasonerConfiguration config_;
    private final boolean isAllowFreshEntities;
    private Reasoner reasoner_;
    private final List<ChangeListener> changeListeners_ = new ArrayList<ChangeListener>();
    private boolean loadBeforeChanges_ = true;
    private boolean ontologyReloadRequired_;

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig, Reasoner internalReasoner) {
        this.owlOntology_ = ontology;
        this.owlOntologymanager_ = ontology.getOWLOntologyManager();
        this.mainProgressMonitor_ = elkConfig.getProgressMonitor() == null ? new DummyProgressMonitor() : new ElkReasonerProgressMonitor(elkConfig.getProgressMonitor());
        this.secondaryProgressMonitor_ = new DummyProgressMonitor();
        this.isBufferingMode_ = isBufferingMode;
        this.ontologyChangeListener_ = new OntologyChangeListener();
        this.owlOntologymanager_.addOntologyChangeListener((OWLOntologyChangeListener)this.ontologyChangeListener_);
        this.ontologyChangeProgressListener_ = new OntologyChangeProgressListener();
        this.owlOntologymanager_.addOntologyChangeProgessListener((OWLOntologyChangeProgressListener)this.ontologyChangeProgressListener_);
        this.objectFactory_ = internalReasoner.getElkFactory();
        this.owlConverter_ = OwlConverter.getInstance();
        this.elkConverter_ = ElkConverter.getInstance();
        this.config_ = elkConfig.getElkConfiguration();
        this.isAllowFreshEntities = elkConfig.getFreshEntityPolicy() == FreshEntityPolicy.ALLOW;
        this.initReasoner(internalReasoner);
        this.bufferedChangesLoader_ = new OwlChangesLoaderFactory(this.mainProgressMonitor_);
        if (!this.isBufferingMode_) {
            this.reasoner_.registerAxiomLoader((AxiomLoader.Factory)this.bufferedChangesLoader_);
        }
        this.ontologyReloadRequired_ = false;
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig) {
        this(ontology, isBufferingMode, elkConfig, new ReasonerFactory().createReasoner(elkConfig.getElkConfiguration()));
    }

    OWLOntology getOWLOntology() {
        return this.owlOntology_;
    }

    ElkObject.Factory getElkObjectFactory() {
        return this.objectFactory_;
    }

    private void initReasoner(Reasoner reasoner) {
        this.reasoner_ = reasoner;
        this.reasoner_.registerAxiomLoader((AxiomLoader.Factory)new OwlOntologyLoader.Factory(this.owlOntology_, this.mainProgressMonitor_));
        this.reasoner_.setAllowFreshEntities(this.isAllowFreshEntities);
        this.reasoner_.setProgressMonitor(this.secondaryProgressMonitor_);
    }

    public Reasoner getInternalReasoner() {
        return this.reasoner_;
    }

    public ReasonerConfiguration getConfigurationOptions() {
        return this.config_;
    }

    public void setConfigurationOptions(ReasonerConfiguration config) {
        this.config_ = config;
        this.reasoner_.setConfigurationOptions(config);
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method) {
        String message = "OWL API reasoner method is not implemented: " + method + ".";
        LoggerWrap.log((Logger)LOGGER_, (LogLevel)LogLevel.WARN, (Marker)MARKER_UNSUPPORTED_METHOD_, (String)message);
        return new UnsupportedOperationException(message);
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method, String reason) {
        String message = "OWL API reasoner method is not fully implemented: " + method + ": " + reason;
        LoggerWrap.log((Logger)LOGGER_, (LogLevel)LogLevel.WARN, (Marker)MARKER_UNSUPPORTED_METHOD_, (String)message);
        return new UnsupportedOperationException(message);
    }

    private IncompleteResult<Node<OWLClass>> getClassNode(ElkClass elkClass) throws FreshEntitiesException, InconsistentOntologyException, ElkException {
        try {
            return this.reasoner_.getEquivalentClasses((ElkClassExpression)elkClass).map(n -> this.elkConverter_.convertClassNode((org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass>)n));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    private IncompleteResult<Node<OWLObjectPropertyExpression>> getObjectPropertyNode(ElkObjectProperty elkClass) throws FreshEntitiesException, InconsistentOntologyException, ElkException {
        try {
            return this.reasoner_.getObjectPropertyNode(elkClass).map(n -> this.elkConverter_.convertObjectPropertyNode((org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkObjectProperty>)n));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    private void checkInterrupted() throws ReasonerInterruptedException {
        try {
            this.reasoner_.checkInterrupt();
        }
        catch (ElkInterruptedException e) {
            throw new ReasonerInterruptedException((Throwable)e);
        }
    }

    public void dispose() {
        LOGGER_.trace("dispose()");
        this.owlOntologymanager_.removeOntologyChangeListener((OWLOntologyChangeListener)this.ontologyChangeListener_);
        this.owlOntologymanager_.removeOntologyChangeProgessListener((OWLOntologyChangeProgressListener)this.ontologyChangeProgressListener_);
        try {
            while (true) {
                try {
                    if (!this.reasoner_.shutdown()) {
                        throw new ReasonerInternalException("Failed to shut down ELK!");
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public void flush() {
        LOGGER_.trace("flush()");
        try {
            if (this.ontologyReloadRequired_) {
                this.initReasoner(new ReasonerFactory().createReasoner(this.reasoner_, this.objectFactory_, this.config_));
                this.bufferedChangesLoader_ = new OwlChangesLoaderFactory(this.secondaryProgressMonitor_);
                this.ontologyReloadRequired_ = false;
            } else {
                if (this.bufferedChangesLoader_.isLoadingFinished()) {
                    return;
                }
                if (this.isBufferingMode_) {
                    this.reasoner_.registerAxiomLoader((AxiomLoader.Factory)this.bufferedChangesLoader_);
                    this.bufferedChangesLoader_ = new OwlChangesLoaderFactory(this.secondaryProgressMonitor_);
                }
            }
            for (ChangeListener listener : this.changeListeners_) {
                listener.ontologyChanged();
            }
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public IncompleteResult<Node<OWLClass>> computeBottomClassNode() {
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLClass> getBottomClassNode() {
        LOGGER_.trace("getBottomClassNode()");
        this.checkInterrupted();
        try {
            return (Node)Incompleteness.getValue(this.computeBottomClassNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getBottomClassNode()", e.getMessage());
        }
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        LOGGER_.trace("getBottomDataPropertyNode()");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getBottomDataPropertyNode()");
    }

    public IncompleteResult<Node<OWLObjectPropertyExpression>> computeBottomObjectPropertyNode() {
        this.checkInterrupted();
        try {
            return this.getObjectPropertyNode(this.objectFactory_.getOwlBottomObjectProperty());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        LOGGER_.trace("getBottomObjectPropertyNode()");
        try {
            return (Node)Incompleteness.getValue(this.computeBottomObjectPropertyNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getBottomObjectPropertyNode()", e.getMessage());
        }
    }

    public BufferingMode getBufferingMode() {
        LOGGER_.trace("getBufferingMode()");
        return this.isBufferingMode_ ? BufferingMode.BUFFERING : BufferingMode.NON_BUFFERING;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDataPropertyDomains(OWLDataProperty, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyDomains(OWLDataProperty, boolean)");
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual arg0, OWLDataProperty arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDataPropertyValues(OWLNamedIndividual, OWLDataProperty)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyValues(OWLNamedIndividual, OWLDataProperty)");
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDifferentIndividuals(OWLNamedIndividual)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDifferentIndividuals(OWLNamedIndividual)");
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression arg0) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("getDisjointClasses(OWLClassExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointClasses(OWLClassExpression)");
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDisjointDataProperties(OWLDataPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointDataProperties(OWLDataPropertyExpression)");
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDisjointObjectProperties(OWLObjectPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointObjectProperties(OWLObjectPropertyExpression)");
    }

    public IncompleteResult<Node<OWLClass>> computeEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getEquivalentClasses(this.owlConverter_.convert(ce)).map(n -> this.elkConverter_.convertClassNode((org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass>)n));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentClasses(OWLClassExpression)");
        try {
            return (Node)Incompleteness.getValue(this.computeEquivalentClasses(ce));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentClasses(OWLClassExpression)", e.getMessage());
        }
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentDataProperties(OWLDataProperty)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentDataProperties(OWLDataProperty)");
    }

    public IncompleteResult<Node<OWLObjectPropertyExpression>> computeEquivalentObjectProperties(OWLObjectProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentObjectProperties(OWLObjectPropertyExpression)");
        this.checkInterrupted();
        try {
            return this.reasoner_.getObjectPropertyNode(this.owlConverter_.convert(pe)).map(n -> this.elkConverter_.convertObjectPropertyNode((org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkObjectProperty>)n));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(OWLObjectPropertyExpression)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentObjectProperties(OWLObjectPropertyExpression)");
        if (pe instanceof OWLObjectProperty) {
            try {
                return (Node)Incompleteness.getValue(this.computeEquivalentObjectProperties((OWLObjectProperty)pe));
            }
            catch (ElkUnsupportedReasoningTaskException e) {
                throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(OWLObjectPropertyExpression)", e.getMessage());
            }
        }
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(OWLObjectPropertyExpression)");
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        LOGGER_.trace("getFreshEntityPolicy()");
        return this.reasoner_.getAllowFreshEntities() ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        LOGGER_.trace("getIndividualNodeSetPolicy()");
        return IndividualNodeSetPolicy.BY_NAME;
    }

    public IncompleteResult<NodeSet<OWLNamedIndividual>> computeInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getInstances(this.owlConverter_.convert(ce), direct).map(nodes -> this.elkConverter_.convertIndividualNodes((Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkNamedIndividual>>)nodes));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getInstances(OWLClassExpression, boolean)");
        this.checkInterrupted();
        try {
            return (NodeSet)Incompleteness.getValue(this.computeInstances(ce, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getInstances(OWLClassExpression, boolean)", e.getMessage());
        }
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getInverseObjectProperties(OWLObjectPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getInverseObjectProperties(OWLObjectPropertyExpression)");
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getObjectPropertyDomains(OWLObjectPropertyExpression, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyDomains(OWLObjectPropertyExpression, boolean)");
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getObjectPropertyRanges(OWLObjectPropertyExpression, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyRanges(OWLObjectPropertyExpression, boolean)");
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual arg0, OWLObjectPropertyExpression arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getObjectPropertyValues(OWLNamedIndividual, OWLObjectPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyValues(OWLNamedIndividual, OWLObjectPropertyExpression)");
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        LOGGER_.trace("getPendingAxiomAdditions()");
        return this.bufferedChangesLoader_.getPendingAxiomAdditions();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        LOGGER_.trace("getPendingAxiomRemovals()");
        return this.bufferedChangesLoader_.getPendingAxiomRemovals();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        LOGGER_.trace("getPendingChanges()");
        return this.bufferedChangesLoader_.getPendingChanges();
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        LOGGER_.trace("getPrecomputableInferenceTypes()");
        return new HashSet<InferenceType>(Arrays.asList(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY));
    }

    public String getReasonerName() {
        LOGGER_.trace("getReasonerName()");
        return ElkReasoner.class.getPackage().getImplementationTitle();
    }

    public Version getReasonerVersion() {
        int filled;
        LOGGER_.trace("getReasonerVersion()");
        String versionString = ElkReasoner.class.getPackage().getImplementationVersion();
        int[] version = new int[4];
        if (versionString != null) {
            String[] splitted = versionString.replaceAll("[^\\d.]", "").split("\\.");
            for (filled = 0; filled < splitted.length && filled < version.length; ++filled) {
                String part = splitted[filled];
                if (part.length() > 8) {
                    part = part.substring(0, 8);
                }
                version[filled] = Integer.parseInt(part);
            }
        }
        while (filled < version.length) {
            version[filled] = 0;
            ++filled;
        }
        return new Version(version[0], version[1], version[2], version[3]);
    }

    public OWLOntology getRootOntology() {
        LOGGER_.trace("getRootOntology()");
        return this.owlOntology_;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSameIndividuals(OWLNamedIndividual)");
        this.checkInterrupted();
        return new OWLNamedIndividualNode(arg0);
    }

    public IncompleteResult<NodeSet<OWLClass>> computeSubClasses(OWLClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSubClasses(this.owlConverter_.convert(ce), direct).map(nodes -> this.elkConverter_.convertClassNodes((Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass>>)nodes));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        LOGGER_.trace("getSubClasses(OWLClassExpression, boolean)");
        try {
            return (NodeSet)Incompleteness.getValue(this.computeSubClasses(ce, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSubClasses(OWLClassExpression, boolean)", e.getMessage());
        }
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSubDataProperties(OWLDataProperty, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSubDataProperties(OWLDataProperty, boolean)");
    }

    public IncompleteResult<NodeSet<OWLObjectPropertyExpression>> computeSubObjectProperties(OWLObjectProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSubObjectProperties(this.owlConverter_.convert(pe), direct).map(nodes -> this.elkConverter_.convertObjectPropertyNodes((Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkObjectProperty>>)nodes));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSubObjectProperties(OWLObjectPropertyExpression, boolean)");
        if (pe instanceof OWLObjectProperty) {
            try {
                return (NodeSet)Incompleteness.getValue(this.computeSubObjectProperties((OWLObjectProperty)pe, direct));
            }
            catch (ElkUnsupportedReasoningTaskException e) {
                throw ElkReasoner.unsupportedOwlApiMethod("getSubObjectProperties(OWLObjectPropertyExpression, boolean)", e.getMessage());
            }
        }
        throw ElkReasoner.unsupportedOwlApiMethod("getSubObjectProperties(OWLObjectPropertyExpression, boolean)");
    }

    public IncompleteResult<NodeSet<OWLClass>> computeSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSuperClasses(this.owlConverter_.convert(ce), direct).map(nodes -> this.elkConverter_.convertClassNodes((Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass>>)nodes));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperClasses(OWLClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSuperClasses(OWLClassExpression, boolean)");
        try {
            return (NodeSet)Incompleteness.getValue(this.computeSuperClasses(ce, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperClasses(OWLClassExpression, boolean)", e.getMessage());
        }
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSuperDataProperties(OWLDataProperty, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperDataProperties(OWLDataProperty, boolean)");
    }

    public IncompleteResult<NodeSet<OWLObjectPropertyExpression>> computeSuperObjectProperties(OWLObjectProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSuperObjectProperties(this.owlConverter_.convert(pe), direct).map(nodes -> this.elkConverter_.convertObjectPropertyNodes((Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkObjectProperty>>)nodes));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(OWLObjectPropertyExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSuperObjectProperties(OWLObjectPropertyExpression, boolean)");
        if (pe instanceof OWLObjectProperty) {
            try {
                return (NodeSet)Incompleteness.getValue(this.computeSuperObjectProperties((OWLObjectProperty)pe, direct));
            }
            catch (ElkUnsupportedReasoningTaskException e) {
                throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(OWLObjectPropertyExpression, boolean)", e.getMessage());
            }
        }
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(OWLObjectPropertyExpression, boolean)");
    }

    public long getTimeOut() {
        LOGGER_.trace("getTimeOut()");
        return 0L;
    }

    public IncompleteResult<Node<OWLClass>> computeTopClassNode() {
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlThing());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLClass> getTopClassNode() {
        LOGGER_.trace("getTopClassNode()");
        this.checkInterrupted();
        try {
            return (Node)Incompleteness.getValue(this.computeTopClassNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTopClassNode()", e.getMessage());
        }
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        LOGGER_.trace("getTopDataPropertyNode()");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getTopDataPropertyNode()");
    }

    public IncompleteResult<Node<OWLObjectPropertyExpression>> computeTopObjectPropertyNode() {
        this.checkInterrupted();
        try {
            return this.getObjectPropertyNode(this.objectFactory_.getOwlTopObjectProperty());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        LOGGER_.trace("getTopObjectPropertyNode()");
        try {
            return (Node)Incompleteness.getValue(this.computeTopObjectPropertyNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTopObjectPropertyNode()", e.getMessage());
        }
    }

    public IncompleteResult<NodeSet<OWLClass>> computeTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getTypes(this.owlConverter_.convert(ind), direct).map(nodes -> this.elkConverter_.convertClassNodes((Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass>>)nodes));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getTypes(OWLNamedIndividual, boolean)");
        try {
            return (NodeSet)Incompleteness.getValue(this.computeTypes(ind, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTypes(OWLNamedIndividual, boolean)", e.getMessage());
        }
    }

    public IncompleteResult<Node<OWLClass>> computeUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        LOGGER_.trace("getUnsatisfiableClasses()");
        this.checkInterrupted();
        try {
            return (Node)Incompleteness.getValue(this.computeUnsatisfiableClasses());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getUnsatisfiableClasses()", e.getMessage());
        }
    }

    public void interrupt() {
        LOGGER_.trace("interrupt()");
        this.reasoner_.interrupt();
    }

    public IncompleteResult<Boolean> checkIsConsistent() {
        try {
            return this.reasoner_.isInconsistent().map(res -> res == false);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("isConsistent()");
        try {
            return (Boolean)Incompleteness.getValue(this.checkIsConsistent());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isConsistent()", e.getMessage());
        }
    }

    public IncompleteResult<Boolean> checkEntailment(OWLAxiom owlAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        try {
            ElkAxiom elkAxiom = this.owlConverter_.convert(owlAxiom);
            VerifiableQueryResult entailment = this.reasoner_.checkEntailment(elkAxiom);
            return new IncompleteResult((Object)entailment.entailmentProved(), entailment.getIncompletenessMonitor());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(OWLAxiom)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isEntailed(OWLAxiom owlAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("isEntailed(OWLAxiom)");
        this.checkInterrupted();
        return (Boolean)Incompleteness.getValue(this.checkEntailment(owlAxiom));
    }

    public boolean isEntailed(Set<? extends OWLAxiom> owlAxioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("isEntailed(Set<? extends OWLAxiom>)");
        this.checkInterrupted();
        try {
            Map results = this.reasoner_.checkEntailment(this.owlConverter_.convertAxiomSet(owlAxioms));
            for (VerifiableQueryResult result : results.values()) {
                if (Incompleteness.getValue((QueryResult)result)) continue;
                return false;
            }
            return true;
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(Set<? extends OWLAxiom>)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        Class<? extends ElkObject> elkAxiomClass = OwlConverter.convertType(axiomType.getActualClass());
        if (elkAxiomClass == null || !ElkAxiom.class.isAssignableFrom(elkAxiomClass)) {
            return false;
        }
        return EntailmentQueryConverter.isEntailmentCheckingSupported(elkAxiomClass.asSubclass(ElkAxiom.class));
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        LOGGER_.trace("isPrecomputed(InferenceType)");
        if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
            return this.reasoner_.doneTaxonomy();
        }
        if (inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) {
            return this.reasoner_.doneInstanceTaxonomy();
        }
        if (inferenceType.equals((Object)InferenceType.OBJECT_PROPERTY_HIERARCHY)) {
            return this.reasoner_.doneObjectPropertyTaxonomy();
        }
        return false;
    }

    public IncompleteResult<? extends Boolean> checkSatisfiability(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.checkInterrupted();
        try {
            return this.reasoner_.isSatisfiable(this.owlConverter_.convert(classExpression));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("isSatisfiable(OWLClassExpression)");
        try {
            return (Boolean)Incompleteness.getValue(this.checkSatisfiability(classExpression));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isSatisfiable(classExpression)", e.getMessage());
        }
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        LOGGER_.trace("precomputeInferences(InferenceType...)");
        this.checkInterrupted();
        this.reasoner_.setProgressMonitor(this.mainProgressMonitor_);
        try {
            for (InferenceType inferenceType : inferenceTypes) {
                if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
                    this.reasoner_.getTaxonomy();
                    continue;
                }
                if (inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) {
                    this.reasoner_.getInstanceTaxonomy();
                    continue;
                }
                if (!inferenceType.equals((Object)InferenceType.OBJECT_PROPERTY_HIERARCHY)) continue;
                this.reasoner_.getObjectPropertyTaxonomy();
            }
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("precomputeInferences(inferenceTypes)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
        finally {
            this.reasoner_.setProgressMonitor(this.secondaryProgressMonitor_);
        }
    }

    public void addListener(ChangeListener listener) {
        this.changeListeners_.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.changeListeners_.remove(listener);
    }

    protected class OntologyChangeListener
    implements OWLOntologyChangeListener {
        protected OntologyChangeListener() {
        }

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            Set importClosure = null;
            for (OWLOntologyChange oWLOntologyChange : changes) {
                OWLOntology changedOntology = oWLOntologyChange.getOntology();
                if (!changedOntology.equals((Object)ElkReasoner.this.owlOntology_)) {
                    if (importClosure == null) {
                        importClosure = ElkReasoner.this.owlOntology_.getImportsClosure();
                    }
                    if (!importClosure.contains(changedOntology)) {
                        LOGGER_.trace("Ignoring the change not applicable to the current ontology: {}" + String.valueOf(oWLOntologyChange));
                        continue;
                    }
                }
                if (!oWLOntologyChange.isAxiomChange()) {
                    LOGGER_.trace("Non-axiom change: {}\n The ontology will be reloaded.", (Object)oWLOntologyChange);
                    ElkReasoner.this.ontologyReloadRequired_ = true;
                    continue;
                }
                ElkReasoner.this.bufferedChangesLoader_.registerChange(oWLOntologyChange);
            }
            if (!ElkReasoner.this.isBufferingMode_) {
                ElkReasoner.this.flush();
            }
        }
    }

    private class OntologyChangeProgressListener
    implements OWLOntologyChangeProgressListener {
        private static final long serialVersionUID = -609834181047406971L;

        private OntologyChangeProgressListener() {
        }

        public void begin(int size) {
            if (ElkReasoner.this.isBufferingMode_ && ElkReasoner.this.loadBeforeChanges_) {
                try {
                    LOGGER_.trace("force initial loading");
                    ElkReasoner.this.reasoner_.ensureLoading();
                    ElkReasoner.this.loadBeforeChanges_ = false;
                }
                catch (ElkException e) {
                    throw ElkReasoner.this.elkConverter_.convert(e);
                }
            }
        }

        public void appliedChange(OWLOntologyChange change) {
        }

        public void end() {
        }
    }

    public static interface ChangeListener {
        public void ontologyChanged();
    }
}

