/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owlapi.OwlOntologyChangeProcessorVisitor;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OwlChangesLoaderFactory
implements AxiomLoader.Factory {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(OwlChangesLoaderFactory.class);
    private final ProgressMonitor progressMonitor;
    private final LinkedList<OWLOntologyChange> pendingChanges_;
    private Loader loader_ = null;

    OwlChangesLoaderFactory(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.pendingChanges_ = new LinkedList();
    }

    private synchronized void load(InterruptMonitor interrupter, ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
        if (!this.pendingChanges_.isEmpty()) {
            OWLOntologyChange change;
            String status = "Loading of Changes";
            this.progressMonitor.start(status);
            int changesCount = this.pendingChanges_.size();
            LOGGER_.trace("{}: {}", (Object)status, (Object)changesCount);
            int currentAxiom = 0;
            while (!interrupter.isInterrupted() && (change = this.pendingChanges_.poll()) != null) {
                if (!change.isAxiomChange()) {
                    ElkLoadingException exception = new ElkLoadingException("Cannot apply non-axiom change!");
                    LOGGER_.error(exception.getMessage(), (Throwable)exception);
                    throw exception;
                }
                OwlOntologyChangeProcessorVisitor loader = new OwlOntologyChangeProcessorVisitor(axiomInserter, axiomDeleter);
                change.accept((OWLOntologyChangeVisitor)loader);
                ElkLoadingException error = loader.getError();
                if (error != null) {
                    LOGGER_.error(error.getMessage(), (Throwable)error);
                    throw error;
                }
                this.progressMonitor.report(++currentAxiom, changesCount);
            }
            this.progressMonitor.finish();
        }
    }

    synchronized boolean isLoadingFinished() {
        return this.pendingChanges_.isEmpty();
    }

    synchronized void registerChange(OWLOntologyChange change) {
        LOGGER_.trace("Registering change: {}", (Object)change);
        this.pendingChanges_.add(change);
    }

    Set<OWLAxiom> getPendingAxiomAdditions() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.pendingChanges_) {
            if (!(change instanceof AddAxiom)) continue;
            added.add(change.getAxiom());
        }
        return added;
    }

    Set<OWLAxiom> getPendingAxiomRemovals() {
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.pendingChanges_) {
            if (!(change instanceof RemoveAxiom)) continue;
            removed.add(change.getAxiom());
        }
        return removed;
    }

    List<OWLOntologyChange> getPendingChanges() {
        return this.pendingChanges_;
    }

    public AxiomLoader getAxiomLoader(InterruptMonitor interrupter) {
        if (this.loader_ == null) {
            this.loader_ = new Loader(interrupter);
        }
        return this.loader_;
    }

    private class Loader
    extends AbstractAxiomLoader {
        public Loader(InterruptMonitor interrupter) {
            super(interrupter);
        }

        public void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
            OwlChangesLoaderFactory.this.load((InterruptMonitor)this, axiomInserter, axiomDeleter);
        }

        public boolean isLoadingFinished() {
            return OwlChangesLoaderFactory.this.isLoadingFinished();
        }
    }
}

