/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi.proofs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.liveontologies.puli.Inference;
import org.liveontologies.puli.Inferences;
import org.liveontologies.puli.Proof;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owlapi.ElkConverter;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.proofs.InternalProof;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.owlapi.model.OWLAxiom;

public class OwlInternalProof
implements Proof<Inference<Object>> {
    private final OwlConverter owlConverter_ = OwlConverter.getInstance();
    private final ElkConverter elkConverter_ = ElkConverter.getInstance();
    private final OWLAxiom goal_;
    private final Inference<Object> goalInference_;
    private final InternalProof proof_;

    public OwlInternalProof(Reasoner reasoner, OWLAxiom goal) {
        this.goal_ = goal;
        ElkAxiom convertedGoal = this.owlConverter_.convert(goal);
        this.goalInference_ = Inferences.create((String)"Converting inference", (Object)goal, Arrays.asList(convertedGoal));
        try {
            this.proof_ = new InternalProof(reasoner, this.owlConverter_.convert(goal));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Object getGoal() {
        return this.goal_;
    }

    public Collection<? extends Inference<Object>> getInferences(Object conclusion) {
        if (this.goal_.equals(conclusion)) {
            List<Inference> result = Arrays.asList(this.goalInference_);
            return result;
        }
        return this.proof_.getInferences(conclusion);
    }
}

