/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.matching;

import org.semanticweb.elk.matching.AbstractChild;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectInverseOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;

public class AbstractMatch<P>
extends AbstractChild<P> {
    public AbstractMatch(P parent) {
        super(parent);
    }

    protected static void checkChainMatch(final ElkSubObjectPropertyExpression fullChain, final int startPos) {
        fullChain.accept((ElkSubObjectPropertyExpressionVisitor)new ElkSubObjectPropertyExpressionVisitor<Void>(){

            void fail() {
                throw new IllegalArgumentException(String.valueOf(fullChain) + ", " + startPos);
            }

            Void defaultVisit(ElkObjectPropertyExpression expression) {
                if (startPos != 0) {
                    this.fail();
                }
                return null;
            }

            public Void visit(ElkObjectPropertyChain expression) {
                if (startPos < 0 || startPos >= expression.getObjectPropertyExpressions().size()) {
                    this.fail();
                }
                return null;
            }

            public Void visit(ElkObjectInverseOf expression) {
                return this.defaultVisit((ElkObjectPropertyExpression)expression);
            }

            public Void visit(ElkObjectProperty expression) {
                return this.defaultVisit((ElkObjectPropertyExpression)expression);
            }
        });
    }

    protected static void checkConjunctionMatch(ElkObjectIntersectionOf conjunction, int prefixLength) {
        if (prefixLength < 1 || prefixLength >= conjunction.getClassExpressions().size()) {
            throw new IllegalArgumentException(String.valueOf(conjunction) + ", " + prefixLength);
        }
    }
}

