/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;

public class ElkClassInclusionExistentialComposition
extends AbstractElkInference {
    public static final String NAME = "Existential Composition";
    private final List<? extends ElkClassExpression> classExpressions_;
    private final List<? extends ElkObjectPropertyExpression> subChain_;
    private final ElkObjectPropertyExpression superProperty_;

    ElkClassInclusionExistentialComposition(List<? extends ElkClassExpression> classExpressions, List<? extends ElkObjectPropertyExpression> subChain, ElkObjectPropertyExpression superProperty) {
        int chainLength = subChain.size();
        if (classExpressions.size() != chainLength + 1) {
            throw new IllegalArgumentException(classExpressions.toString() + " is expected to contain one more element than " + subChain.toString());
        }
        this.classExpressions_ = classExpressions;
        this.subChain_ = subChain;
        this.superProperty_ = superProperty;
    }

    public List<? extends ElkClassExpression> getClassExpressions() {
        return this.classExpressions_;
    }

    public List<? extends ElkObjectPropertyExpression> getSubChain() {
        return this.subChain_;
    }

    public ElkObjectPropertyExpression getSuperProperty() {
        return this.superProperty_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return this.classExpressions_.size();
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        if (index < this.getExistentialPremiseCount()) {
            return this.getExistentialPremise(index, factory);
        }
        return this.getLastPremise(factory);
    }

    public int getExistentialPremiseCount() {
        return this.classExpressions_.size() - 1;
    }

    public ElkSubClassOfAxiom getExistentialPremise(int index, ElkObject.Factory factory) {
        if (index < 0 || index >= this.getExistentialPremiseCount()) {
            throw new IndexOutOfBoundsException("No existential premise with index: " + index);
        }
        return factory.getSubClassOfAxiom(this.classExpressions_.get(index), (ElkClassExpression)factory.getObjectSomeValuesFrom(this.subChain_.get(index), this.classExpressions_.get(index + 1)));
    }

    public ElkSubObjectPropertyOfAxiom getLastPremise(ElkObject.Factory factory) {
        return factory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)(this.subChain_.size() == 1 ? (ElkSubObjectPropertyExpression)this.subChain_.get(0) : factory.getObjectPropertyChain(this.subChain_)), this.superProperty_);
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom(this.classExpressions_.get(0), (ElkClassExpression)factory.getObjectSomeValuesFrom(this.superProperty_, this.classExpressions_.get(this.classExpressions_.size() - 1)));
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionExistentialComposition var1);
    }

    public static interface Factory {
        public ElkClassInclusionExistentialComposition getElkClassInclusionExistentialComposition(List<? extends ElkClassExpression> var1, List<? extends ElkObjectPropertyExpression> var2, ElkObjectPropertyExpression var3);
    }
}

