/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.Arrays;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;

public class ElkClassInclusionExistentialTransitivity
extends AbstractElkInference {
    public static final String NAME = "Existential Transitivity Composition";
    private final List<? extends ElkClassExpression> classExpressions_;
    private final ElkObjectPropertyExpression transitiveProperty_;

    ElkClassInclusionExistentialTransitivity(ElkObjectPropertyExpression transitiveProperty, List<? extends ElkClassExpression> classExpressions) {
        if (classExpressions.size() < 3) {
            throw new IllegalArgumentException(classExpressions.toString());
        }
        this.classExpressions_ = classExpressions;
        this.transitiveProperty_ = transitiveProperty;
    }

    ElkClassInclusionExistentialTransitivity(ElkObjectPropertyExpression transitiveProperty, ElkClassExpression ... classExpressions) {
        this(transitiveProperty, Arrays.asList(classExpressions));
    }

    public List<? extends ElkClassExpression> getClassExpressions() {
        return this.classExpressions_;
    }

    public ElkObjectPropertyExpression getTransitiveProperty() {
        return this.transitiveProperty_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return this.classExpressions_.size();
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        if (index < this.getExistentialPremiseCount()) {
            return this.getExistentialPremise(index, factory);
        }
        return this.getLastPremise(factory);
    }

    public int getExistentialPremiseCount() {
        return this.classExpressions_.size() - 1;
    }

    public ElkSubClassOfAxiom getExistentialPremise(int index, ElkObject.Factory factory) {
        if (index < 0 || index >= this.getExistentialPremiseCount()) {
            throw new IndexOutOfBoundsException("No existential premise with index: " + index);
        }
        return factory.getSubClassOfAxiom(this.classExpressions_.get(index), (ElkClassExpression)factory.getObjectSomeValuesFrom(this.transitiveProperty_, this.classExpressions_.get(index + 1)));
    }

    public ElkTransitiveObjectPropertyAxiom getLastPremise(ElkObject.Factory factory) {
        return factory.getTransitiveObjectPropertyAxiom(this.transitiveProperty_);
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom(this.classExpressions_.get(0), (ElkClassExpression)factory.getObjectSomeValuesFrom(this.transitiveProperty_, this.classExpressions_.get(this.classExpressions_.size() - 1)));
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionExistentialTransitivity var1);
    }

    public static interface Factory {
        public ElkClassInclusionExistentialTransitivity getElkClassInclusionExistentialTransitivity(ElkObjectPropertyExpression var1, ElkClassExpression ... var2);

        public ElkClassInclusionExistentialTransitivity getElkClassInclusionExistentialTransitivity(ElkObjectPropertyExpression var1, List<? extends ElkClassExpression> var2);
    }
}

